/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    protected FileUtil() {
    }

    public static String convertWildcardToRegex(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\.", "\\\\.");
        string2 = string2.replaceAll("\\?", ".");
        string2 = string2.replaceAll("\\*", ".*");
        return string2;
    }

    public static String convertWindowsWildcardToRegex(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '*') {
                stringBuffer.append(".*");
                continue;
            }
            if (cArray[i] == '?') {
                stringBuffer.append(".");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(cArray[i]) >= 0) {
                stringBuffer.append('\\').append(cArray[i]);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static File[] filterFilesByWildcard(File[] fileArray, String string, boolean bl) {
        String string2 = FileUtil.convertWildcardToRegex(string);
        return FileUtil.filterFilesByRegex(fileArray, string2, bl);
    }

    public static File[] filterFilesByRegex(File[] fileArray, String string, boolean bl) {
        File[] fileArray2 = new File[fileArray.length];
        if (bl) {
            string = string.toLowerCase();
        }
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == null) {
                fileArray2[i] = null;
                continue;
            }
            String string2 = fileArray[i].getName().toString();
            if (bl) {
                string2 = string2.toLowerCase();
            }
            if (string2.matches(string)) {
                fileArray2[i] = fileArray[i];
                ++n;
                continue;
            }
            fileArray2[i] = null;
        }
        if (n < fileArray.length) {
            File[] fileArray3 = new File[n];
            int n2 = 0;
            for (int i = 0; i < fileArray2.length; ++i) {
                if (fileArray2[i] == null) continue;
                fileArray3[n2++] = fileArray2[i];
            }
            fileArray2 = fileArray3;
        }
        return fileArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String string, String string2) {
        File file = null;
        File file2 = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = true;
        int n = 1024;
        byte[] byArray = new byte[n];
        try {
            int n2;
            file = new File(string);
            file2 = new File(string2);
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            while ((n2 = fileInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            byArray = null;
            file = null;
            file2 = null;
            fileInputStream = null;
            fileOutputStream = null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(InputStream inputStream, String string) {
        File file = null;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = true;
        int n = 1024;
        byte[] byArray = new byte[n];
        try {
            int n2;
            file = new File(string);
            bufferedInputStream = new BufferedInputStream(inputStream);
            fileOutputStream = new FileOutputStream(file);
            while ((n2 = bufferedInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            byArray = null;
            file = null;
            bufferedInputStream = null;
            fileOutputStream = null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyTextFile(String string, String string2) {
        File file = null;
        File file2 = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        boolean bl = true;
        try {
            String string3;
            file = new File(string);
            file2 = new File(string2);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            fileWriter = new FileWriter(file2);
            bufferedWriter = new BufferedWriter(fileWriter);
            while ((string3 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string3 + "\n");
            }
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            file = null;
            file2 = null;
            fileReader = null;
            bufferedReader = null;
            fileWriter = null;
            bufferedWriter = null;
        }
        return bl;
    }

    public static String fixFileName1(String string) {
        Object object = string;
        File file = new File(string);
        if (file.isAbsolute() && Character.isLetter(string.charAt(0))) {
            object = "/" + (String)object;
        }
        return object;
    }
}

