/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.util;

import de.admadic.util.FileUtil;
import de.admadic.util.VersionUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ClassPathExtender {
    static boolean DBG = false;
    static final boolean LOG = true;
    static final Logger logger = Logger.getLogger("de.admadic");
    ArrayList<File> files;
    ArrayList<URL> urls;
    URLClassLoader urlClassLoader;

    public ClassPathExtender() {
        String string = System.getProperty("admadic.debug");
        if (string != null && string.toLowerCase().equals("yes")) {
            DBG = true;
        }
        this.files = new ArrayList();
        this.urls = new ArrayList();
        if (logger != null) {
            logger.fine("ClassPathExtender started.");
        }
    }

    public void registerToThread(Thread thread) {
        if (this.urls == null) {
            if (logger != null) {
                logger.info("registerToThread: no urls there.");
            }
            return;
        }
        if (this.urlClassLoader == null) {
            this.generateClassLoader();
        }
        if (thread == null) {
            thread = Thread.currentThread();
        }
        thread.setContextClassLoader(this.urlClassLoader);
    }

    public void generateClassLoader() {
        this.convertFilesToURLs();
        URL[] uRLArray = new URL[this.urls.size()];
        uRLArray = this.urls.toArray(uRLArray);
        if (logger != null) {
            for (URL uRL : uRLArray) {
                logger.finest("classpath entry -> " + uRL.toString());
            }
        }
        this.urlClassLoader = new URLClassLoader(uRLArray);
    }

    protected void convertFilesToURLs() {
        for (int i = 0; i < this.files.size(); ++i) {
            URL uRL;
            if (this.files.get(i) == null) continue;
            try {
                uRL = this.files.get(i).toURL();
                if (logger != null) {
                    logger.fine("setURLs: adding " + uRL.toString());
                }
                if (DBG) {
                    System.out.println("CPE: setURLs: adding " + uRL.toString());
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (logger != null) {
                    logger.severe("could not get URL for " + this.files.get(i).toString());
                }
                if (DBG) {
                    System.out.println("CPE: could not get URL for " + this.files.get(i).toString());
                }
                uRL = null;
            }
            if (uRL == null) continue;
            this.urls.add(uRL);
        }
    }

    protected void checkFileVersions() {
        VersionUtil.removeOldVersions(this.files);
    }

    public void setURLs(String[] stringArray) {
        File[] fileArray = this.createFileArray(stringArray);
        this.setURLs(fileArray);
    }

    public void setURLs(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == null) continue;
            this.files.add(fileArray[i]);
        }
    }

    public void setURLs(File file, String string) {
        File[] fileArray = file.listFiles();
        fileArray = FileUtil.filterFilesByWildcard(fileArray, string, true);
        this.setURLs(fileArray);
    }

    public ClassLoader getClassLoader() {
        return this.urlClassLoader;
    }

    protected URL[] compactURLArray(URL[] uRLArray, int n) {
        if (n < 0) {
            n = 0;
            for (int i = 0; i < uRLArray.length; ++i) {
                if (uRLArray[i] == null) continue;
                ++n;
            }
        }
        URL[] uRLArray2 = new URL[n];
        int n2 = 0;
        for (int i = 0; i < uRLArray.length; ++i) {
            if (uRLArray[i] == null) continue;
            uRLArray2[n2++] = uRLArray[i];
        }
        return uRLArray2;
    }

    protected File[] createFileArray(String[] stringArray) {
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        return fileArray;
    }

    public void dumpUrls() {
    }
}

