/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.util;

import de.admadic.util.BitOp;
import de.admadic.util.CharCodeOpException;
import java.util.ArrayList;

public class CharCodeOp {
    String codeMap;

    public CharCodeOp(String string) {
        this.codeMap = string;
    }

    public int string2Num(String string) throws CharCodeOpException {
        long l = 0L;
        if (string == null) {
            return 0;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            l *= (long)this.codeMap.length();
            int n = this.codeMap.indexOf(c);
            if (n < 0) {
                throw new CharCodeOpException("Invalid character found: " + c);
            }
            if (l > 0xFFFFFFFEL) {
                throw new CharCodeOpException("Overflow (" + string + " too large)");
            }
            l += (long)n;
        }
        return (int)l;
    }

    public String num2String(int n) {
        Object object;
        int n2 = this.codeMap.length();
        long l = n;
        if (n == 0) {
            object = this.codeMap.substring(0, 1);
        } else {
            object = "";
            while (l != 0L) {
                int n3 = (int)((l & 0xFFFFFFFFL) % (long)n2);
                object = this.codeMap.charAt(n3) + (String)object;
                l = (l & 0xFFFFFFFFL) / (long)n2;
            }
        }
        return object;
    }

    public String bytes2String(byte[] byArray, int n, int n2) {
        Object object = "";
        int n3 = BitOp.bytes2Int(byArray, 0, n);
        object = this.num2String(n3);
        while (((String)object).length() < n2) {
            object = this.codeMap.substring(0, 1) + (String)object;
        }
        return object;
    }

    public byte[] string2Bytes(String string, int n) throws CharCodeOpException {
        int n2 = this.string2Num(string);
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        BitOp.int2Bytes(n2, byArray, 0, n);
        return byArray;
    }

    public String[] encodeBytes2Strings(byte[] byArray, int n, int n2) {
        int n3;
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < byArray.length; i += n) {
            byte[] byArray2 = new byte[n];
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray2[n3] = 0;
            }
            int n4 = n;
            if (byArray.length - i < n) {
                n4 = byArray.length - i;
            }
            System.arraycopy(byArray, i, byArray2, 0, n4);
            string = this.bytes2String(byArray2, n, n2);
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = (String)arrayList.get(n3);
        }
        arrayList = null;
        return stringArray;
    }

    public byte[] decodeStrings2Bytes(String[] stringArray, int n, int n2) throws CharCodeOpException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (String string : stringArray) {
            byte[] byArray2 = this.string2Bytes(string, n);
            for (int i = 0; i < byArray2.length; ++i) {
                if (n3 + i >= byArray.length) continue;
                byArray[n3 + i] = byArray2[i];
            }
            n3 += n;
        }
        return byArray;
    }
}

