/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class StringPrinter {
    static final boolean DBG = false;
    String text;
    JFrame parent;
    JDialog parent2;
    int fontSize;
    Font font;

    public StringPrinter(JFrame jFrame, String string) {
        this.text = string;
        this.parent = jFrame;
    }

    public StringPrinter(JDialog jDialog, String string) {
        this.text = string;
        this.parent2 = jDialog;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public synchronized void doPrint(boolean bl) {
        Font font;
        Font font2 = this.font != null ? this.font : (font = new Font("Monospaced", 0, this.fontSize > 0 ? this.fontSize : 12));
        if (bl) {
            BusyDialog busyDialog = new BusyDialog((Frame)this.parent, "Printing", "Printing in background. Please wait...", false);
            busyDialog.setVisible(true);
            new Thread(new PrintingThread(this.text, font)).start();
            busyDialog.setVisible(false);
        } else {
            BusyDialog busyDialog = new BusyDialog((Frame)this.parent, "Printing", "Printing... Please wait...", false);
            busyDialog.setVisible(true);
            new PrintingThread(this.text, font).run();
            busyDialog.setVisible(false);
        }
    }

    public static class PrintTestPagePainter
    implements Printable {
        String text;
        ArrayList<ArrayList<String>> pages;
        PageFormat curPageFormat;
        Font printFont;

        public PrintTestPagePainter(String string, Font font) {
            this.text = this.fixEmptyLFs(string);
            this.printFont = font;
        }

        String fixEmptyLFs(String string) {
            Object object = string;
            if (((String)object).startsWith("\n")) {
                object = " " + (String)object;
            }
            while (((String)object).indexOf("\n\n") >= 0) {
                object = ((String)object).replaceAll("\n\n", "\n \n");
            }
            return object;
        }

        public int calculatePageCount(PageFormat pageFormat) {
            ArrayList<ArrayList<String>> arrayList = this.repaginate(pageFormat);
            return arrayList.size();
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (this.curPageFormat != pageFormat) {
                this.curPageFormat = pageFormat;
                this.pages = this.repaginate(pageFormat);
            }
            if (n >= this.pages.size()) {
                return 1;
            }
            graphics.setFont(this.printFont);
            graphics.setColor(Color.black);
            this.renderPage(graphics, pageFormat, n);
            return 0;
        }

        int countChar(String string, char c) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != c) continue;
                ++n;
            }
            return n;
        }

        int[] createIndexArray(String string, char c, int[] nArray) {
            int n;
            if (nArray == null) {
                n = this.countChar(string, c);
                if (n == 0) {
                    return null;
                }
                nArray = new int[n];
            }
            n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != c) continue;
                nArray[n] = i;
                if (++n >= nArray.length) break;
            }
            return nArray;
        }

        ArrayList<ArrayList<String>> repaginate(PageFormat pageFormat) {
            ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
            ArrayList<String> arrayList2 = null;
            double d = pageFormat.getImageableHeight();
            int n = this.printFont.getSize();
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
            AttributedString attributedString = new AttributedString(this.text);
            attributedString.addAttribute(TextAttribute.FONT, this.printFont);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            float f = (float)pageFormat.getImageableWidth();
            int[] nArray = this.createIndexArray(this.text, '\n', null);
            double d2 = 0.0;
            int n2 = 0;
            int n3 = 0;
            arrayList2 = new ArrayList<String>();
            arrayList.add(arrayList2);
            while (lineBreakMeasurer.getPosition() < this.text.length()) {
                int n4;
                TextLayout textLayout;
                int n5 = lineBreakMeasurer.getPosition();
                if (nArray == null) {
                    textLayout = lineBreakMeasurer.nextLayout(f);
                } else {
                    n3 = n2 < nArray.length ? nArray[n2] : this.text.length();
                    textLayout = lineBreakMeasurer.nextLayout(f, n3, false);
                    if (lineBreakMeasurer.getPosition() >= n3) {
                        ++n2;
                    }
                }
                if (textLayout == null) {
                    // empty if block
                }
                if ((n4 = lineBreakMeasurer.getPosition()) == n5) {
                    // empty if block
                }
                if ((d2 += (double)n) > d) {
                    d2 = 0.0;
                    arrayList2 = new ArrayList();
                    arrayList.add(arrayList2);
                }
                arrayList2.add(this.text.substring(n5, n4));
            }
            return arrayList;
        }

        void renderPage(Graphics graphics, PageFormat pageFormat, int n) {
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            int n4 = this.printFont.getSize();
            ArrayList<String> arrayList = this.pages.get(n);
            for (String string : arrayList) {
                graphics.drawString(string, n2, n4 + n3);
                n4 += this.printFont.getSize();
            }
        }
    }

    public static class PrintingThread
    implements Runnable {
        String text;
        Font font;

        public PrintingThread(String string, Font font) {
            this.text = string;
            this.font = font;
        }

        @Override
        public void run() {
            PageFormat pageFormat;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            Book book = new Book();
            PrintTestPagePainter printTestPagePainter = new PrintTestPagePainter(this.text, this.font);
            PageFormat pageFormat2 = printerJob.defaultPage();
            if (pageFormat2 == (pageFormat = printerJob.pageDialog(pageFormat2))) {
                return;
            }
            int n = printTestPagePainter.calculatePageCount(pageFormat);
            book.append(printTestPagePainter, pageFormat, n);
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(null, "An error occured during printing:\n" + printerException.getMessage(), "Printing Error", 0);
                }
            }
        }
    }

    public static class BusyDialog
    extends JDialog {
        JTextArea text;
        private static final long serialVersionUID = 1L;

        public BusyDialog(Frame frame, String string, String string2, boolean bl) throws HeadlessException {
            if (bl) {
                // empty if block
            }
            super(frame, string, false);
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            JPanel jPanel = new JPanel();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            jPanel.setLayout(new BorderLayout());
            this.text = new JTextArea();
            this.text.setEditable(false);
            this.text.setOpaque(false);
            jPanel.add((Component)this.text, "Center");
            this.text.setText(string2);
            this.pack();
            this.setLocationRelativeTo(frame);
        }
    }
}

