/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import de.admadic.ui.util.ISplashWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SplashWindow
extends JWindow
implements ISplashWindow {
    private static final long serialVersionUID = 1L;
    protected static final boolean DBGforce = false;
    JLayeredPane layeredPane;
    JPanel lowerPanel;
    JPanel upperPanel;
    JLabel pictureLabel;
    JProgressBar progress;
    JLabel labelTitle;
    JTextArea textDetails;
    boolean useTimeout;
    boolean useUserclick;
    boolean useProgress;
    boolean waitForCompletion;
    boolean stopAllThreads;
    MouseAdapter mouseClickListener;
    String lastMessage;
    int lastPercent;
    Runnable waitRunner;
    Runnable closeRunner;
    Runnable updateRunner;
    int splashDelay;
    Thread delayThread;

    public SplashWindow(Icon icon, String string, String string2, String string3, int n) {
        if (string != null) {
            this.useProgress = true;
        }
        this.initRunners();
        this.initVisuals(icon, string, string2, string3, n);
    }

    public void setWaitForCompletion(boolean bl) {
        this.waitForCompletion = bl;
    }

    public void setUserClose(boolean bl) {
        this.useUserclick = bl;
        if (!this.useUserclick && this.mouseClickListener != null) {
            this.removeMouseListener(this.mouseClickListener);
            this.mouseClickListener = null;
        }
        if (this.useUserclick && this.mouseClickListener == null) {
            this.mouseClickListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SplashWindow.this.delayThread == null) {
                        if (SplashWindow.this.waitForCompletion && SplashWindow.this.useProgress && SplashWindow.this.lastPercent < 100) {
                            return;
                        }
                        SplashWindow.this.setVisible(false);
                        SplashWindow.this.dispose();
                    } else {
                        SplashWindow.this.delayThread.interrupt();
                    }
                }
            };
            this.addMouseListener(this.mouseClickListener);
        }
    }

    public void setDelayedClose(int n) {
        if (n < 1) {
            return;
        }
        this.splashDelay = n;
        this.waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(SplashWindow.this.splashDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (SplashWindow.this.waitForCompletion) {
                        while (SplashWindow.this.lastPercent < 100 && !SplashWindow.this.stopAllThreads) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    try {
                        SwingUtilities.invokeAndWait(SplashWindow.this.closeRunner);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SplashWindow.this.delayThread = null;
            }
        };
        this.delayThread = new Thread(this.waitRunner, "SplashThread");
    }

    @Override
    public void close() {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(this.closeRunner);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.delayThread != null && !this.delayThread.isAlive() && !this.stopAllThreads) {
            this.delayThread.start();
        }
        super.setVisible(bl);
    }

    @Override
    public void updateStatus(String string) {
        this.updateStatus(string, -1);
    }

    @Override
    public void updateStatus(String string, int n) {
        this.lastMessage = string;
        if (n >= 0) {
            this.lastPercent = n;
        }
        if (this.useProgress && this.isVisible() && this.updateRunner != null) {
            SwingUtilities.invokeLater(this.updateRunner);
        }
    }

    @Override
    public void notifyCompleted() {
        this.updateStatus(this.lastMessage, 100);
    }

    protected void initVisuals(Icon icon, String string, String string2, String string3, int n) {
        Dimension dimension;
        this.layeredPane = new JLayeredPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.lowerPanel = new JPanel();
        Color color = new Color(240, 240, 240);
        Color color2 = new Color(0, 0, 0);
        this.lowerPanel.setBackground(color);
        this.lowerPanel.setLayout(new BorderLayout());
        this.upperPanel = new JPanel();
        this.upperPanel.setLayout(null);
        this.upperPanel.setOpaque(false);
        this.pictureLabel = new JLabel(icon);
        this.lowerPanel.add((Component)this.pictureLabel, "Center");
        if (string2 != null) {
            this.labelTitle = new JLabel(string2, 0);
            this.labelTitle.setForeground(color2);
            this.lowerPanel.add((Component)this.labelTitle, "North");
        }
        if (this.useProgress) {
            this.progress = new JProgressBar(0, 100);
            this.progress.setForeground(color2);
            this.progress.setBorderPainted(false);
            this.progress.setBackground(color);
            this.progress.setStringPainted(true);
            this.progress.setString(string);
            this.lowerPanel.add((Component)this.progress, "South");
        }
        this.lowerPanel.setBorder(new LineBorder(color2, 1));
        this.upperPanel.setPreferredSize(this.lowerPanel.getPreferredSize());
        this.layeredPane.setPreferredSize(this.lowerPanel.getPreferredSize());
        if (string3 != null) {
            this.textDetails = new JTextArea();
            this.textDetails.setEditable(false);
            this.textDetails.setOpaque(false);
            this.textDetails.setText(string3);
            this.textDetails.setMargin(new Insets(5, 5, 5, 5));
            this.textDetails.setFont(this.textDetails.getFont().deriveFont(0, 9.0f));
            if (n > 0) {
                dimension = this.upperPanel.getPreferredSize();
                this.upperPanel.add(this.textDetails);
                this.textDetails.setBounds(0, n, dimension.width, dimension.height - n);
            } else {
                this.upperPanel.setLayout(new BorderLayout());
                this.upperPanel.add((Component)this.textDetails, "South");
            }
        }
        this.layeredPane.add((Component)this.lowerPanel, new Integer(1));
        this.layeredPane.add((Component)this.upperPanel, new Integer(2));
        this.getContentPane().add((Component)this.layeredPane, "Center");
        this.pack();
        dimension = this.lowerPanel.getPreferredSize();
        Rectangle rectangle = this.lowerPanel.getBounds();
        if (rectangle.width == 0) {
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        this.lowerPanel.setBounds(rectangle);
        if (string3 != null) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.x = 0;
            if (this.labelTitle != null) {
                rectangle2.y += this.labelTitle.getPreferredSize().height;
                rectangle2.height -= this.labelTitle.getPreferredSize().height;
            }
            if (this.progress != null) {
                rectangle2.height -= this.progress.getPreferredSize().height;
            }
            this.upperPanel.setBounds(rectangle2);
        } else {
            this.upperPanel.setBounds(rectangle);
        }
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
    }

    protected void setStopAllThreads(boolean bl) {
        if (!bl) {
            return;
        }
        this.stopAllThreads = true;
        if (this.delayThread != null) {
            this.delayThread.interrupt();
        }
    }

    protected void initRunners() {
        this.closeRunner = new Runnable(){

            @Override
            public void run() {
                if (SplashWindow.this.stopAllThreads) {
                    return;
                }
                SplashWindow.this.setStopAllThreads(true);
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        };
        if (this.useProgress) {
            this.updateRunner = new Runnable(){

                @Override
                public void run() {
                    if (SplashWindow.this.progress != null) {
                        SplashWindow.this.progress.setValue(SplashWindow.this.lastPercent);
                        SplashWindow.this.progress.setString(SplashWindow.this.lastMessage);
                    }
                }
            };
        }
    }
}

