/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class SeparatedListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    JSeparator separator;
    static Border m_noFocusBorder;
    FontMetrics m_fm = null;
    Insets m_insets = new Insets(0, 0, 0, 0);
    int m_defaultTab = 8;
    int[] m_tabs = null;
    int maxcharwidth = -1;

    public SeparatedListCellRenderer() {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.separator = new JSeparator(0);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object == null) {
            return this.separator;
        }
        String string = object.toString();
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setFont(jList.getFont());
        this.setText(string);
        return this;
    }

    public void setDefaultTab(int n) {
        this.m_defaultTab = n;
    }

    public int getDefaultTab() {
        return this.m_defaultTab;
    }

    public void setTabs(int[] nArray) {
        this.m_tabs = nArray;
    }

    public int[] getTabs() {
        return this.m_tabs;
    }

    public int getTab(int n) {
        if (this.m_tabs == null) {
            return this.m_defaultTab * n;
        }
        int n2 = this.m_tabs.length;
        if (n >= 0 && n < n2) {
            return this.m_tabs[n];
        }
        return this.m_tabs[n2 - 1] + this.m_defaultTab * (n - n2 + 1);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        this.m_fm = graphics.getFontMetrics();
        int n2 = this.maxcharwidth;
        if (n2 < 0) {
            int[] nArray = this.m_fm.getWidths();
            n = 0;
            int n3 = 0;
            for (int n4 : nArray) {
                if (n4 <= 0) continue;
                ++n;
                n3 += n4;
            }
            n3 = n == 0 ? 10 : (n3 /= n);
            n2 = n3;
        }
        if (this.maxcharwidth < 0) {
            this.maxcharwidth = n2;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getBorder().paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        this.m_insets = this.getInsets();
        int n5 = this.m_insets.left;
        n = this.m_insets.top + this.m_fm.getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            graphics.drawString(string, n5, n);
            n5 += this.m_fm.stringWidth(string);
            if (!stringTokenizer.hasMoreTokens()) break;
            int n6 = 0;
            while (n5 >= n2 * this.getTab(n6)) {
                ++n6;
            }
            n5 = n2 * this.getTab(n6);
        }
    }

    @Override
    public void updateUI() {
        this.maxcharwidth = -1;
        super.updateUI();
    }
}

