/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.Dialog;
import de.admadic.ui.util.StringPrinter;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicTextViewDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    JScrollPane spLicText;
    JTextArea taLicText;
    JButton btnAccept;
    JButton btnClose;
    JButton btnPrint;
    JPanel pnButtons;
    boolean accepted;

    public LicTextViewDialog(JFrame jFrame) {
        this(jFrame, false);
    }

    public LicTextViewDialog(JFrame jFrame, boolean bl) {
        super(jFrame);
        this.initGUI(bl);
    }

    public void setText(String string) {
        this.taLicText.setText(string);
        this.taLicText.setCaretPosition(0);
        this.spLicText.getVerticalScrollBar().setValue(0);
    }

    public void setLicSrc(File file) {
        Object object = "";
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                object = (String)object + string + "\n";
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.logger != null) {
                this.logger.severe("Could not find the license text file @" + file.toString() + " error: " + fileNotFoundException.getMessage());
            }
            object = "Error: The license file could not be found.\nIt should be at " + file.toString();
        }
        catch (IOException iOException) {
            if (this.logger != null) {
                this.logger.severe("Could read from the license text file @" + file.toString() + " error: " + iOException.getMessage());
            }
            object = "Error: Could not read the license file.\nIt is located at " + file.toString();
        }
        this.setText((String)object);
    }

    public void setLicSrc(InputStream inputStream) {
        Object object = "";
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                object = (String)object + string + "\n";
            }
        }
        catch (IOException iOException) {
            if (this.logger != null) {
                this.logger.severe("Could read from the license text.  error: " + iOException.getMessage());
            }
            object = "Error: Could not read the license file.\nPlease contact customer support.";
        }
        this.setText((String)object);
    }

    public void doPrint() {
        StringPrinter stringPrinter = new StringPrinter(this, this.taLicText.getText());
        stringPrinter.setFontSize(10);
        stringPrinter.doPrint(false);
    }

    private void initGUI(boolean bl) {
        block4: {
            try {
                this.setTitle("License Information - admaDIC Calculator");
                if (bl) {
                    this.setModal(true);
                }
                FormLayout formLayout = new FormLayout("5px, p, 5px", "5px, p, 5px, p, 5px");
                this.getContentPane().setLayout(formLayout);
                this.spLicText = new JScrollPane();
                this.getContentPane().add((Component)this.spLicText, new CellConstraints("2, 2, 1, 1, default, default"));
                this.taLicText = new JTextArea();
                this.spLicText.setViewportView(this.taLicText);
                this.taLicText.setText("<license text>");
                this.taLicText.setColumns(80);
                this.taLicText.setRows(20);
                this.taLicText.setEditable(false);
                this.taLicText.setFont(new Font("Monospaced", 0, 14));
                this.pnButtons = new JPanel();
                this.pnButtons.setOpaque(false);
                this.getContentPane().add((Component)this.pnButtons, new CellConstraints("2, 4, 1, 1, default, default"));
                if (bl) {
                    this.btnAccept = new JButton();
                    this.pnButtons.add(this.btnAccept);
                    this.btnAccept.setText("Accept");
                    this.btnAccept.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            LicTextViewDialog.this.setAccepted(true);
                            LicTextViewDialog.this.dispose();
                        }
                    });
                }
                this.btnClose = new JButton();
                this.pnButtons.add(this.btnClose);
                this.btnClose.setText(bl ? "Decline" : "Close");
                this.btnClose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LicTextViewDialog.this.dispose();
                    }
                });
                this.btnPrint = new JButton();
                this.pnButtons.add(this.btnPrint);
                this.btnPrint.setText("Print...");
                this.btnPrint.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LicTextViewDialog.this.doPrint();
                    }
                });
                this.pack();
                this.setLocationRelativeTo(null);
            }
            catch (Exception exception) {
                if (this.logger == null) break block4;
                this.logger.severe("Error creating the license view dialog: " + exception.getMessage());
            }
        }
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean bl) {
        this.accepted = bl;
    }
}

