/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.Dialog;
import de.admadic.ui.util.FilteredListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;

public class LaFAddDialog
extends Dialog
implements ActionListener {
    JLabel labelClassFilter;
    JTextField textClassFilter;
    JLabel labelClassList;
    JList listClasses;
    FilteredListModel listModel;
    JScrollPane scrollClasses;
    JPanel panelButtons;
    JButton buttonOk;
    JButton buttonCancel;
    JLabel labelLaFs;
    JScrollPane scrollLaFs;
    JTable tableLaFs;
    LaFTableModel tableModelLaFs;
    String[] tableColumnsLaFs;
    String[][] tableDataLaFs;
    boolean lafTableNotifyFlag = true;
    JPanel panelLaFButtons;
    JButton buttonAddAllLaFs;
    JButton buttonAddLaF;
    JButton buttonRemAllLaFs;
    JButton buttonRemLaF;
    JPanel panelFilterModes;
    JToggleButton buttonFilterBegin;
    JToggleButton buttonFilterInside;
    JToggleButton buttonFilterEnd;
    ButtonGroup btnGrpFilter;
    JTextArea textMsg;
    boolean requireInList = true;
    String filter;
    String selectedClassName;
    static final String CMD_OK = "cmd.ok";
    static final String CMD_CANCEL = "cmd.cancel";
    static final String CMD_ADD_LAF = "cmd.add.laf";
    static final String CMD_ADD_ALLLAFS = "cmd.add.alllafs";
    static final String CMD_REM_LAF = "cmd.rem.laf";
    static final String CMD_REM_ALLLAFS = "cmd.rem.alllafs";
    ArrayList<String> listClassNamesEngine;
    ArrayList<String> resultDisplayNames;
    ArrayList<String> resultClassNames;
    private static final long serialVersionUID = 1L;

    public LaFAddDialog(Frame frame) throws HeadlessException {
        super(frame);
        this.initGUI();
    }

    public LaFAddDialog(java.awt.Dialog dialog) throws HeadlessException {
        super(dialog);
        this.initGUI();
    }

    protected void initGUI() {
        FormLayout formLayout = new FormLayout("12px, 250px, 12px, p, 12px, 250px, 12px", "12px, p, 5px, p, 12px, p, 5px, 150px, 12px, p, 12px,p, 12px");
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.labelClassFilter = new JLabel("Class filter:");
        this.textClassFilter = new JTextField("");
        this.labelClassList = new JLabel("List of classes for potential Look-and-Feels:");
        this.listClasses = new JList();
        this.scrollClasses = new JScrollPane(this.listClasses);
        this.panelButtons = new JPanel();
        this.buttonOk = new JButton("OK");
        this.panelButtons.add(this.buttonOk);
        this.buttonCancel = new JButton("Cancel");
        this.panelButtons.add(this.buttonCancel);
        this.labelLaFs = new JLabel("Look-and-Feels to be installed:");
        this.tableLaFs = new JTable();
        this.tableModelLaFs = new LaFTableModel();
        this.scrollLaFs = new JScrollPane(this.tableLaFs);
        this.buttonFilterBegin = new JToggleButton("|<-");
        this.buttonFilterInside = new JToggleButton("><");
        this.buttonFilterEnd = new JToggleButton("->|");
        this.panelFilterModes = new JPanel();
        this.textMsg = new JTextArea();
        Object object = new FormLayout("p:grow, 5px, p, 5px, p, 5px, p", "p");
        Object object2 = new CellConstraints();
        this.panelFilterModes.setLayout((LayoutManager)object);
        this.panelFilterModes.add((Component)this.textClassFilter, ((CellConstraints)object2).xy(1, 1));
        this.panelFilterModes.add((Component)this.buttonFilterBegin, ((CellConstraints)object2).xy(3, 1));
        this.panelFilterModes.add((Component)this.buttonFilterInside, ((CellConstraints)object2).xy(5, 1));
        this.panelFilterModes.add((Component)this.buttonFilterEnd, ((CellConstraints)object2).xy(7, 1));
        this.buttonAddLaF = new JButton("+ >");
        this.buttonAddAllLaFs = new JButton(">>");
        this.buttonRemLaF = new JButton("X");
        this.buttonRemAllLaFs = new JButton("XX");
        object = new FormLayout("p", "p, 5px, p, 5px, p, 5px, p");
        object2 = new CellConstraints();
        this.panelLaFButtons = new JPanel();
        this.panelLaFButtons.setLayout((LayoutManager)object);
        this.panelLaFButtons.add((Component)this.buttonAddLaF, ((CellConstraints)object2).xy(1, 1));
        this.panelLaFButtons.add((Component)this.buttonAddAllLaFs, ((CellConstraints)object2).xy(1, 3));
        this.panelLaFButtons.add((Component)this.buttonRemLaF, ((CellConstraints)object2).xy(1, 5));
        this.panelLaFButtons.add((Component)this.buttonRemAllLaFs, ((CellConstraints)object2).xy(1, 7));
        this.add((Component)this.labelClassFilter, cellConstraints.xy(2, 2));
        this.add((Component)this.panelFilterModes, cellConstraints.xy(2, 4));
        this.add((Component)this.labelClassList, cellConstraints.xy(2, 6));
        this.add((Component)this.scrollClasses, cellConstraints.xy(2, 8, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.add((Component)this.panelButtons, cellConstraints.xywh(2, 12, 5, 1));
        this.add((Component)this.panelLaFButtons, cellConstraints.xy(4, 8, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.add((Component)this.labelLaFs, cellConstraints.xy(6, 6, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.add((Component)this.scrollLaFs, cellConstraints.xy(6, 8));
        this.add((Component)this.textMsg, cellConstraints.xywh(2, 10, 5, 1));
        this.listModel = new FilteredListModel();
        this.listModel.setFilterType(2);
        this.listClasses.setModel(this.listModel);
        this.listClasses.getSelectionModel().setSelectionMode(0);
        this.scrollClasses.setVerticalScrollBarPolicy(22);
        this.scrollClasses.setHorizontalScrollBarPolicy(32);
        this.buttonOk.setActionCommand(CMD_OK);
        this.buttonCancel.setActionCommand(CMD_CANCEL);
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.registerEnterAction(this.buttonOk);
        this.registerEscapeAction();
        this.btnGrpFilter = new ButtonGroup();
        this.btnGrpFilter.add(this.buttonFilterBegin);
        this.btnGrpFilter.add(this.buttonFilterInside);
        this.btnGrpFilter.add(this.buttonFilterEnd);
        this.buttonFilterEnd.setSelected(true);
        object = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = itemEvent.getSource();
                int n = 0;
                if (object == LaFAddDialog.this.buttonFilterBegin) {
                    n = 1;
                } else if (object == LaFAddDialog.this.buttonFilterInside) {
                    n = 0;
                } else if (object == LaFAddDialog.this.buttonFilterEnd) {
                    n = 2;
                }
                LaFAddDialog.this.listModel.setFilterType(n);
                LaFAddDialog.this.listModel.updateFilter();
            }
        };
        this.buttonFilterBegin.addItemListener((ItemListener)object);
        this.buttonFilterInside.addItemListener((ItemListener)object);
        this.buttonFilterEnd.addItemListener((ItemListener)object);
        this.buttonFilterBegin.setMargin(new Insets(1, 1, 1, 1));
        this.buttonFilterInside.setMargin(new Insets(1, 1, 1, 1));
        this.buttonFilterEnd.setMargin(new Insets(1, 1, 1, 1));
        object2 = this.textClassFilter.getDocument();
        object2.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateList(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateList(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void updateList(DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    // empty if block
                }
                String string = LaFAddDialog.this.textClassFilter.getText();
                LaFAddDialog.this.listModel.updateFilter(string);
            }
        });
        this.scrollLaFs.setHorizontalScrollBarPolicy(32);
        this.scrollLaFs.setVerticalScrollBarPolicy(22);
        this.tableColumnsLaFs = new String[]{"Display Name", "Class Name"};
        this.tableDataLaFs = new String[0][0];
        this.tableModelLaFs.setColumns(this.tableColumnsLaFs);
        this.tableModelLaFs.setData(this.tableDataLaFs);
        this.tableLaFs.setModel(this.tableModelLaFs);
        this.buttonAddLaF.setActionCommand(CMD_ADD_LAF);
        this.buttonAddAllLaFs.setActionCommand(CMD_ADD_ALLLAFS);
        this.buttonRemLaF.setActionCommand(CMD_REM_LAF);
        this.buttonRemAllLaFs.setActionCommand(CMD_REM_ALLLAFS);
        this.buttonAddLaF.addActionListener(this);
        this.buttonAddAllLaFs.addActionListener(this);
        this.buttonRemLaF.addActionListener(this);
        this.buttonRemAllLaFs.addActionListener(this);
        this.textMsg.setOpaque(false);
        this.textMsg.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.textMsg.setRows(2);
        this.textMsg.setText("Ok");
        this.buttonFilterBegin.setToolTipText("Match at beginning of class name");
        this.buttonFilterEnd.setToolTipText("Match at end of class name");
        this.buttonFilterInside.setToolTipText("Match anywhere in class name");
        this.buttonAddLaF.setToolTipText("Add selected class to Look-and-Feel table");
        this.buttonAddAllLaFs.setToolTipText("Add all listed classes to Look-and-Feel table");
        this.buttonRemLaF.setToolTipText("Remove selected entry from Look-and-Feel table");
        this.buttonRemAllLaFs.setToolTipText("Remove all entries from Look-and-Feel table");
        this.scrollLaFs.setToolTipText("List of Look-and-Feels which shall be installed");
        this.scrollClasses.setToolTipText("List of potentially available Look-and-Feels");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
    }

    protected void errorMsg(String string, boolean bl) {
        this.textMsg.setText(string);
        this.textMsg.setForeground(bl ? Color.RED : Color.BLACK);
    }

    protected String getDisplayNameFromClassName(String string) {
        int n;
        Object object = string;
        int n2 = string.indexOf(".");
        int n3 = string.indexOf(".", n2 + 1);
        Object object2 = n2 >= 0 && n3 > n2 ? string.substring(n2 + 1, n3) : ((n2 = string.lastIndexOf(".")) >= 0 ? string.substring(0, n2) : "");
        if (((String)object2).length() > 0) {
            object2 = (String)object2 + "-";
        }
        if (((String)object).endsWith("LookAndFeel")) {
            object = ((String)object).substring(0, ((String)object).length() - "LookAndFeel".length());
        }
        if ((n = ((String)object).lastIndexOf(".")) >= 0) {
            object = ((String)object).substring(n + 1);
        }
        object = ((String)object).length() < 1 ? string : (String)object2 + (String)object;
        return object;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.errorMsg("Ok", false);
        if (string.equals(CMD_OK)) {
            this.resultDisplayNames = new ArrayList();
            this.resultClassNames = new ArrayList();
            for (int i = 0; i < this.tableDataLaFs.length; ++i) {
                this.resultDisplayNames.add(this.tableDataLaFs[i][0]);
                this.resultClassNames.add(this.tableDataLaFs[i][1]);
            }
            this.setResultCode(1);
            this.setVisible(false);
        } else if (string.equals(CMD_CANCEL)) {
            this.setResultCode(2);
            this.setVisible(false);
        } else if (string.equals(CMD_ADD_LAF)) {
            String string2 = (String)this.listClasses.getSelectedValue();
            if (string2 == null) {
                this.errorMsg("No class selected from list.", true);
                return;
            }
            String string3 = this.getDisplayNameFromClassName(string2);
            this.lafTableAdd(string3, string2);
        } else if (string.equals(CMD_ADD_ALLLAFS)) {
            this.lafTableNotify(false);
            int n = this.listModel.getSize();
            for (int i = 0; i < n; ++i) {
                String string4 = (String)this.listModel.getElementAt(i);
                String string5 = this.getDisplayNameFromClassName(string4);
                this.lafTableAdd(string5, string4);
            }
            this.lafTableNotify(true);
        } else if (string.equals(CMD_REM_LAF)) {
            int n = this.tableLaFs.getSelectedRow();
            if (n < 0) {
                this.errorMsg("No entry selected in Look-and-Feel table.", true);
                return;
            }
            this.lafTableRemove(n);
        } else if (string.equals(CMD_REM_ALLLAFS)) {
            this.lafTableRemoveAll();
        }
    }

    protected void lafTableNotify(boolean bl) {
        this.lafTableNotifyFlag = bl;
        if (bl) {
            this.tableModelLaFs.fireTableStructureChanged();
        }
    }

    protected void lafTableAdd(String string, String string2) {
        String[][] stringArray = new String[this.tableDataLaFs.length + 1][2];
        for (int i = 0; i < this.tableDataLaFs.length; ++i) {
            stringArray[i][0] = this.tableDataLaFs[i][0];
            stringArray[i][1] = this.tableDataLaFs[i][1];
        }
        stringArray[stringArray.length - 1][0] = string;
        stringArray[stringArray.length - 1][1] = string2;
        this.tableDataLaFs = stringArray;
        this.tableModelLaFs.setData(this.tableDataLaFs);
        if (this.lafTableNotifyFlag) {
            this.tableModelLaFs.fireTableRowsInserted(stringArray.length - 1, stringArray.length - 1);
        }
    }

    protected void lafTableRemove(int n) {
        int n2 = this.tableDataLaFs.length - 1;
        String[][] stringArray = new String[n2][2];
        if (n2 > 0) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                stringArray[n4][0] = this.tableDataLaFs[n3][0];
                stringArray[n4][1] = this.tableDataLaFs[n3][1];
                ++n4;
            }
            for (n3 = n + 1; n3 < this.tableDataLaFs.length; ++n3) {
                stringArray[n4][0] = this.tableDataLaFs[n3][0];
                stringArray[n4][1] = this.tableDataLaFs[n3][1];
                ++n4;
            }
        }
        this.tableDataLaFs = stringArray;
        this.tableModelLaFs.setData(this.tableDataLaFs);
        if (this.lafTableNotifyFlag) {
            this.tableModelLaFs.fireTableRowsDeleted(n, n);
        }
    }

    protected void lafTableRemoveAll() {
        String[][] stringArray = new String[0][2];
        this.tableDataLaFs = stringArray;
        this.tableModelLaFs.setData(this.tableDataLaFs);
        if (this.lafTableNotifyFlag) {
            this.tableModelLaFs.fireTableStructureChanged();
        }
    }

    protected boolean checkIsInList(String string) {
        boolean bl = false;
        if (this.listClassNamesEngine.contains(string)) {
            return true;
        }
        return bl;
    }

    public boolean isRequireInList() {
        return this.requireInList;
    }

    public void setRequireInList(boolean bl) {
        this.requireInList = bl;
    }

    public void addClasses(String[] stringArray) {
        if (this.listClassNamesEngine == null) {
            this.listClassNamesEngine = new ArrayList();
        }
        for (String string : stringArray) {
            this.listClassNamesEngine.add(string);
        }
    }

    public void updateControls() {
        this.listModel.clear();
        this.listModel.addList(this.listClassNamesEngine);
        this.updateControlsFilter();
        this.pack();
    }

    protected void updateControlsFilter() {
        this.listModel.updateFilter(this.filter);
        if (this.listModel.getSize() == 1) {
            this.listClasses.setSelectedIndex(0);
        }
        if (!this.isVisible()) {
            this.pack();
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String string) {
        this.filter = string;
        this.textClassFilter.setText(string);
        this.updateControlsFilter();
    }

    public String getSelectedClassName() {
        return this.selectedClassName;
    }

    public void setSelectedClassName(String string) {
        this.selectedClassName = string;
    }

    public int getResultNamesCount() {
        if (this.resultDisplayNames == null) {
            return 0;
        }
        return this.resultDisplayNames.size();
    }

    public String getResultDisplayName(int n) {
        if (this.resultDisplayNames == null) {
            return null;
        }
        return this.resultDisplayNames.get(n);
    }

    public String getResultClassName(int n) {
        if (this.resultClassNames == null) {
            return null;
        }
        return this.resultClassNames.get(n);
    }

    public String[] getResultDisplayNames() {
        String[] stringArray = null;
        if (this.resultDisplayNames == null) {
            return stringArray;
        }
        stringArray = new String[this.resultDisplayNames.size()];
        return this.resultDisplayNames.toArray(stringArray);
    }

    public String[] getResultClassNames() {
        String[] stringArray = null;
        if (this.resultClassNames == null) {
            return stringArray;
        }
        stringArray = new String[this.resultClassNames.size()];
        return this.resultClassNames.toArray(stringArray);
    }

    class LaFTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columns = null;
        private Object[][] data = null;

        LaFTableModel() {
        }

        public void setColumns(String[] stringArray) {
            this.columns = stringArray;
        }

        public void setData(Object[][] objectArray) {
            this.data = objectArray;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            if (this.columns == null) {
                return null;
            }
            if (n < 0 || n >= this.columns.length) {
                return null;
            }
            return this.columns[n];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.data == null) {
                return;
            }
            if (n < 0 || n >= this.data.length) {
                return;
            }
            if (n2 < 0 || n2 >= this.data[n].length) {
                return;
            }
            this.data[n][n2] = object;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            if (this.columns == null) {
                return 0;
            }
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.data == null) {
                return null;
            }
            if (n < 0 || n >= this.data.length) {
                return null;
            }
            if (n2 < 0 || this.data[n] == null || n2 >= this.data[n].length) {
                return null;
            }
            return this.data[n][n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }
}

