/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class Colorizer {
    protected Colorizer() {
    }

    protected static Color adjustColor_Impl(Color color, Color color2, Color color3, double d) {
        FColor fColor = null;
        if (color != null) {
            fColor = new FColor(color);
        }
        FColor fColor2 = new FColor(color2);
        FColor fColor3 = new FColor(color3);
        FColor fColor4 = new FColor(fColor2);
        double d2 = fColor != null ? fColor.getLuminance() : 0.5;
        double d3 = fColor2.getLuminance();
        double d4 = fColor3.getLuminance();
        double d5 = 1.0;
        double d6 = d5 * d;
        fColor3.add(-d4);
        fColor3.mul(d6);
        fColor3.spread();
        fColor4.add(fColor3);
        fColor4.normalize();
        return fColor4.generateColor();
    }

    public static Color adjustColor(Color color, Color color2, Color color3) {
        return Colorizer.adjustColor(color, color2, color3, 0.25);
    }

    public static Color adjustColor(Color color, Color color2, Color color3, double d) {
        return Colorizer.adjustColor_Impl(color, color2, color3, d);
    }

    public static ImageIcon adjustImageColor(Image image, Color color, Color color2, Color color3) {
        return Colorizer.adjustImageColor_Impl(image, color, color2, color3, 0.25);
    }

    public static ImageIcon adjustImageColor(Image image, Color color, Color color2, Color color3, double d) {
        return Colorizer.adjustImageColor_Impl(image, color, color2, color3, d);
    }

    protected static ImageIcon adjustImageColor_Impl(Image image, Color color, Color color2, Color color3, double d) {
        Hashtable<Color, Color> hashtable = new Hashtable<Color, Color>();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Color color4;
                nArray = writableRaster.getPixel(j, i, nArray);
                Color color5 = new Color(nArray[0], nArray[1], nArray[2]);
                if (color3 != null) {
                    color5 = color3;
                }
                if (hashtable.containsKey(color5)) {
                    color4 = (Color)hashtable.get(color5);
                } else {
                    color4 = Colorizer.adjustColor(color, color2, color5, d);
                    if (hashtable.size() < 100) {
                        hashtable.put(color5, color4);
                    }
                }
                nArray[0] = color4.getRed();
                nArray[1] = color4.getGreen();
                nArray[2] = color4.getBlue();
                writableRaster.setPixel(j, i, nArray);
            }
        }
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        hashtable = null;
        return imageIcon;
    }

    public static ImageIcon makeIcon(Image image, boolean bl, Color color, Color color2, Color color3) {
        ImageIcon imageIcon = bl ? Colorizer.adjustImageColor(image, color, color2, color3, 0.07) : new ImageIcon(image);
        return imageIcon;
    }

    static class FColor {
        double red;
        double green;
        double blue;
        double alpha;

        public FColor() {
            this(0.0, 0.0, 0.0);
        }

        public FColor(FColor fColor) {
            this.red = fColor.red;
            this.green = fColor.green;
            this.blue = fColor.blue;
            this.alpha = fColor.alpha;
        }

        public FColor(double d, double d2, double d3, double d4) {
            this.red = d;
            this.green = d2;
            this.blue = d3;
            this.alpha = d4;
        }

        public FColor(double d, double d2, double d3) {
            this(d, d2, d3, 1.0);
        }

        public FColor(Color color) {
            this.red = (double)color.getRed() / 255.0;
            this.green = (double)color.getGreen() / 255.0;
            this.blue = (double)color.getBlue() / 255.0;
            this.alpha = 1.0;
        }

        public double getLuminance() {
            return 0.3 * this.red + 0.59 * this.green + 0.11 * this.blue;
        }

        public void mul(double d) {
            this.red *= d;
            this.green *= d;
            this.blue *= d;
        }

        public void spread() {
            this.red *= 5.0;
            this.green *= 1.4492753623188408;
            this.blue *= 9.090909090909092;
        }

        public void mul(FColor fColor) {
            this.red *= fColor.red;
            this.green *= fColor.green;
            this.blue *= fColor.blue;
        }

        public void add(double d) {
            this.red += d;
            this.green += d;
            this.blue += d;
        }

        public void add(FColor fColor) {
            this.red += fColor.red;
            this.green += fColor.green;
            this.blue += fColor.blue;
        }

        public void normalize() {
            double d = 0.0;
            double d2 = 0.0;
            if (this.red > 1.0) {
                d = Math.max(d, this.red - 1.0);
            }
            if (this.green > 1.0) {
                d = Math.max(d, this.green - 1.0);
            }
            if (this.blue > 1.0) {
                d = Math.max(d, this.blue - 1.0);
            }
            if (this.red < 0.0) {
                d2 = Math.min(d2, this.red);
            }
            if (this.green < 0.0) {
                d2 = Math.min(d2, this.green);
            }
            if (this.blue < 0.0) {
                d2 = Math.min(d2, this.blue);
            }
            if (d > 0.0 || d2 < 0.0) {
                this.red = (this.red - d2) / (d - d2 + 1.0);
                this.green = (this.green - d2) / (d - d2 + 1.0);
                this.blue = (this.blue - d2) / (d - d2 + 1.0);
            }
        }

        public Color generateColor() {
            return new Color((int)(this.red * 255.0), (int)(this.green * 255.0), (int)(this.blue * 255.0));
        }
    }
}

