/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import java.awt.Color;
import java.util.Collections;
import java.util.Vector;

public class ColorGradient {
    Vector<GradientItem> gradientItems = new Vector();

    public ColorGradient() {
    }

    public ColorGradient(Color color, Color color2) {
        this.setColor(0.0, color);
        this.setColor(1.0, color2);
    }

    public ColorGradient(Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = objectArray[i];
            Double d = (Double)objectArray2[0];
            Color color = (Color)objectArray2[1];
            this.setColorImpl(d, color);
        }
        this.sortImpl();
    }

    public static ColorGradient JET() {
        ColorGradient colorGradient = new ColorGradient(new Object[][]{{0.0, Color.decode("#0000C0")}, {0.125, Color.decode("#0000FF")}, {0.375, Color.decode("#00FFFF")}, {0.625, Color.decode("#FFFF00")}, {0.875, Color.decode("#FF0000")}, {1.0, Color.decode("#C00000")}});
        return colorGradient;
    }

    public void setColor(double d, Color color) {
        this.setColor((Double)d, color);
    }

    public void setColor(Double d, Color color) {
        this.setColorImpl(d, color);
        this.sortImpl();
    }

    public Color calculateColorAtPos(double d) {
        GradientItem gradientItem;
        GradientItem gradientItem2;
        Color color = null;
        int n = Collections.binarySearch(this.gradientItems, d);
        if (n >= 0) {
            gradientItem2 = this.gradientItems.elementAt(n);
            gradientItem = null;
        } else if ((n = -n - 1) == 0) {
            gradientItem2 = this.gradientItems.firstElement();
            gradientItem = null;
        } else if (n == this.gradientItems.size()) {
            gradientItem2 = this.gradientItems.lastElement();
            gradientItem = null;
        } else {
            gradientItem2 = this.gradientItems.elementAt(n - 1);
            gradientItem = this.gradientItems.elementAt(n);
        }
        if (gradientItem == null) {
            color = new Color(gradientItem2.getColor().getRGB());
        } else {
            Color color2 = gradientItem2.getColor();
            Color color3 = gradientItem.getColor();
            double d2 = gradientItem2.getPos();
            double d3 = gradientItem.getPos();
            color = this.interpolateColor(d2, d3, d, color2, color3);
        }
        return color;
    }

    private float interpolate(double d, double d2, double d3, float f, float f2) {
        return (float)((double)f + (double)(f2 - f) * (d3 - d) / (d2 - d));
    }

    private Color interpolateColor(double d, double d2, double d3, Color color, Color color2) {
        float[] fArray = color.getRGBColorComponents(null);
        float[] fArray2 = color2.getRGBColorComponents(null);
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray3[i] = this.interpolate(d, d2, d3, fArray[i], fArray2[i]);
        }
        return new Color(fArray3[0], fArray3[1], fArray3[2]);
    }

    private void setColorImpl(Double d, Color color) {
        this.gradientItems.add(new GradientItem(d, color));
    }

    private void sortImpl() {
        Collections.sort(this.gradientItems);
    }

    protected class GradientItem
    implements Comparable {
        Double pos;
        Color color;

        public GradientItem(Double d, Color color) {
            this.pos = d;
            this.color = color;
        }

        public GradientItem(double d, Color color) {
            this.pos = d;
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Double getPos() {
            return this.pos;
        }

        public void setPos(Double d) {
            this.pos = d;
        }

        public int compareTo(Object object) {
            Double d = object instanceof Double ? (Double)object : ((GradientItem)object).pos;
            if (d < this.pos) {
                return 1;
            }
            if (d > this.pos) {
                return -1;
            }
            return 0;
        }
    }
}

