/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.util;

import de.admadic.spiromat.log.Logger;

public class PrimitiveTimerProbe {
    Logger logger;
    long startTime;
    public static final int UNIT_NS = 0;
    public static final int UNIT_MS = 1;
    public static final int UNIT_US = 2;
    String[] units = new String[]{"ns", "ms", "us"};
    double[] factors = new double[]{1.0, 1000000.0, 1000.0};

    public PrimitiveTimerProbe(Logger logger) {
        this.logger = logger;
        this.startTime = System.nanoTime();
    }

    public void probe(String string, int n) {
        long l = System.nanoTime() - this.startTime;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("probe[" + this.units[n] + "] for [" + string + "] = " + (double)l / this.factors[n]);
        }
    }

    public void probeAndReset(String string, int n) {
        long l = System.nanoTime() - this.startTime;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("probe[" + this.units[n] + "] for [" + string + "] = " + (double)l / this.factors[n]);
        }
        this.startTime += l;
    }
}

