/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.util;

import de.admadic.spiromat.SpiromatException;

public class LoadMonitor {
    String name;
    long startIntervalSum;
    long startIntervalMin;
    long startIntervalMax;
    long startIntervalCount;
    long runDurationSum;
    long runDurationMin;
    long runDurationMax;
    long runDurationCount;
    long lastStart;
    static final int STATUS_NONE = 0;
    static final int STATUS_START = 1;
    static final int STATUS_STOP = 2;
    int lastStatus = 0;
    boolean autoReset = true;

    public LoadMonitor(String string) {
        this.name = string;
        this.reset();
    }

    public LoadMonitor(String string, boolean bl) {
        this.autoReset = bl;
        this.name = string;
        this.reset();
    }

    public void reset() {
        this.startIntervalSum = 0L;
        this.startIntervalMin = 0L;
        this.startIntervalMax = 0L;
        this.startIntervalCount = 0L;
        this.runDurationSum = 0L;
        this.runDurationMin = 0L;
        this.runDurationMax = 0L;
        this.runDurationCount = 0L;
        this.lastStatus = 0;
    }

    public void start() {
        if (this.lastStatus == 0) {
            this.lastStart = System.nanoTime();
            this.lastStatus = 1;
            return;
        }
        if (this.lastStatus != 2) {
            throw new SpiromatException("invalid call sequence (no stop before start)");
        }
        this.lastStatus = 1;
        long l = System.nanoTime() - this.lastStart;
        this.startIntervalSum += l;
        if (l > this.startIntervalMax) {
            this.startIntervalMax = l;
        }
        if (l < this.startIntervalMin || this.startIntervalMin == 0L) {
            this.startIntervalMin = l;
        }
        ++this.startIntervalCount;
        this.lastStart = System.nanoTime();
    }

    public void stop() {
        if (this.lastStatus == 0) {
            throw new RuntimeException("stop called without calling start first");
        }
        if (this.lastStatus != 1) {
            throw new RuntimeException("invalid call sequence (no start before stop)");
        }
        this.lastStatus = 2;
        long l = System.nanoTime() - this.lastStart;
        this.runDurationSum += l;
        if (l > this.runDurationMax) {
            this.runDurationMax = l;
        }
        if (l < this.runDurationMin || this.runDurationMin == 0L) {
            this.runDurationMin = l;
        }
        ++this.runDurationCount;
        if (this.runDurationCount % 50L == 0L) {
            this.dump();
            if (this.autoReset) {
                this.reset();
            }
        }
    }

    public void dump() {
    }

    public double getStartAvg() {
        return (double)this.startIntervalSum * 1.0 / (double)this.startIntervalCount;
    }

    public double getRunAvg() {
        return (double)this.runDurationSum * 1.0 / (double)this.runDurationCount;
    }

    public void dumpDead() {
        if (this.startIntervalCount == 0L || this.runDurationCount == 0L) {
            System.out.println("not enough data");
            return;
        }
        double d = (double)this.startIntervalSum * 1.0 / (double)this.startIntervalCount;
        double d2 = (double)this.runDurationSum * 1.0 / (double)this.runDurationCount;
        double d3 = d2 / d;
        double d4 = (double)(this.startIntervalMax - this.startIntervalMin) / d;
        double d5 = (double)(this.runDurationMax - this.runDurationMin) / d;
        d4 = (double)Math.round(d4 * 1000.0) / 1000.0;
        d5 = (double)Math.round(d5 * 1000.0) / 1000.0;
        d3 = (double)Math.round(d3 * 1000.0) / 1000.0;
        System.out.println("timing stats: [" + this.name + "]\n\tstart=" + d + " / " + this.startIntervalMin + " / " + this.startIntervalMax + " c=" + this.startIntervalCount + "\n\trun=" + d2 + " / " + this.runDurationMin + " / " + this.runDurationMax + " c=" + this.runDurationCount + "\n\tload=" + d3);
        System.out.println("timing stats [" + this.name + "]: load=" + d3 + " (sj=" + d4 + " rj=" + d5 + ")");
    }

    public void dumpLoad() {
        if (this.startIntervalCount == 0L || this.runDurationCount == 0L) {
            System.out.println("not enough data");
            return;
        }
        double d = (double)this.startIntervalSum * 1.0 / (double)this.startIntervalCount;
        double d2 = (double)this.runDurationSum * 1.0 / (double)this.runDurationCount;
        double d3 = d2 / d;
        double d4 = (double)(this.startIntervalMax - this.startIntervalMin) / d;
        double d5 = (double)(this.runDurationMax - this.runDurationMin) / d;
        d4 = (double)Math.round(d4 * 1000.0) / 1000.0;
        d5 = (double)Math.round(d5 * 1000.0) / 1000.0;
        d3 = (double)Math.round(d3 * 1000.0) / 1000.0;
        System.out.println("timing stats [" + this.name + "]: load=" + d3 + " (sj=" + d4 + " rj=" + d5 + ")");
    }

    public void dumpRunTime() {
        if (this.startIntervalCount == 0L || this.runDurationCount == 0L) {
            System.out.println("not enough data");
            return;
        }
        double d = (double)this.startIntervalSum * 1.0 / (double)this.startIntervalCount;
        double d2 = (double)this.runDurationSum * 1.0 / (double)this.runDurationCount;
        double d3 = d2 / d;
        double d4 = this.runDurationMax;
        double d5 = this.runDurationMin;
        double d6 = (double)(this.startIntervalMax - this.startIntervalMin) / d;
        double d7 = (double)(this.runDurationMax - this.runDurationMin) / d;
        d6 = (double)Math.round(d6 * 1000.0) / 1000.0;
        d7 = (double)Math.round(d7 * 1000.0) / 1000.0;
        d3 = (double)Math.round(d3 * 1000.0) / 1000.0;
        System.out.println("timing stats [us]: [" + this.name + "]  run=" + (d2 /= 1000.0) + " / " + (d5 /= 1000.0) + " / " + (d4 /= 1000.0) + " c=" + this.runDurationCount);
    }
}

