/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.util;

public class Knob {
    private double angle = 0.0;
    private double direction = 0.0;
    private int rounds = 0;

    public void reset() {
        this.setAngle(0.0);
    }

    public double updateKnobFromMousePos(int n, int n2) {
        double d;
        double d2 = Math.atan2(n2, n);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        if ((d = Knob.getOpenAngle(this.direction, d2)) == 0.0) {
            return this.angle;
        }
        this.direction += d;
        if (d > 0.0) {
            if (this.direction > Math.PI * 2) {
                this.direction -= Math.PI * 2;
                ++this.rounds;
            }
        } else if (this.direction < 0.0) {
            this.direction += Math.PI * 2;
            --this.rounds;
        }
        this.angle = (double)this.rounds * Math.PI * 2.0 + this.direction;
        return this.angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.rounds = (int)Math.floor(d / Math.PI / 2.0);
        this.direction = this.angle - (double)this.rounds * Math.PI * 2.0;
    }

    protected static double getOpenAngle(double d, double d2) {
        double d3 = d2 - d;
        if (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        } else if (d3 < -Math.PI) {
            d3 += Math.PI * 2;
        }
        if (d3 == -Math.PI) {
            d3 = Math.PI;
        }
        return d3;
    }
}

