/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.util;

import de.admadic.spiromat.SpiromatException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;

public class FileExport {
    public static void export(BufferedImage bufferedImage, File file, Format format) throws IOException {
        String string = null;
        switch (format) {
            case AUTO: {
                string = FileExport.getFormatFromFileName(file);
                break;
            }
            case JPEG: {
                string = "jpg";
                break;
            }
            case PNG: {
                string = "png";
                break;
            }
            default: {
                throw new SpiromatException("unsupported export format: " + format);
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, string, file);
    }

    private static String getFormatFromFileName(File file) {
        String string = FilenameUtils.getExtension(file.getName());
        if (string.toLowerCase().equals("jpg") || string.toLowerCase().equals("jpeg")) {
            return "jpg";
        }
        if (string.toLowerCase().equals("png")) {
            return "png";
        }
        throw new SpiromatException("could not detect graphics format from file extension: file=" + file.toString());
    }

    public static enum Format {
        AUTO,
        JPEG,
        PNG;

    }
}

