/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.util;

import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.shapes.FigureView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;

public class BitmapExport {
    DocModel docModel;
    Color backgroundColor = null;

    public BitmapExport(DocModel docModel) {
        this(docModel, null);
    }

    public BitmapExport(DocModel docModel, Color color) {
        this.docModel = docModel;
        this.backgroundColor = color;
    }

    public BufferedImage export() {
        ArrayList<FigureView> arrayList = new ArrayList<FigureView>();
        arrayList.clear();
        int n = this.docModel.getFigureSpecCount();
        for (int i = 0; i < n; ++i) {
            Iterator iterator = this.docModel.getFigureSpec(i);
            FigureView figureView = new FigureView((FigureSpec)((Object)iterator));
            figureView.setVisible(true);
            figureView.setIgnoreActiveStatus(true);
            arrayList.add(figureView);
        }
        BufferedImage bufferedImage = new BufferedImage(1000, 1000, this.backgroundColor == null ? 2 : 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(500, 500);
        for (FigureView figureView : arrayList) {
            figureView.drawStayingParts(graphics2D);
        }
        for (FigureView figureView : arrayList) {
            figureView.drawVolatileParts(graphics2D);
        }
        return bufferedImage;
    }
}

