/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.shapes.Drawable;
import de.admadic.spiromat.util.PrimitiveTimerProbe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;

public class SpiromatCanvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final Logger logger = Logger.getLogger(SpiromatCanvas.class);
    private Dimension dimensionForTransform = null;
    private AffineTransform canvasTransform;
    private BufferedImage stayingBackBuffer = null;
    private BufferedImage volatileBackBuffer = null;
    private boolean hasVirginBuffers = false;
    private Object renderLock = new Object();
    final Color BGCOLOR = AppModel.getInstance().getColorCanvas();

    public SpiromatCanvas() {
        this.setBackground(this.BGCOLOR);
        this.setOpaque(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewBackBuffers() {
        logger.debug("creating new back buffers...");
        Object object = this.renderLock;
        synchronized (object) {
            PrimitiveTimerProbe primitiveTimerProbe = new PrimitiveTimerProbe(logger);
            if (this.stayingBackBuffer == null) {
                this.stayingBackBuffer = new BufferedImage(1000, 1000, 1);
            }
            primitiveTimerProbe.probeAndReset("created staying back buffer", 2);
            if (this.volatileBackBuffer == null) {
                this.volatileBackBuffer = new BufferedImage(1000, 1000, 1);
            }
            primitiveTimerProbe.probeAndReset("created volatile back buffer", 2);
            Graphics2D graphics2D = this.stayingBackBuffer.createGraphics();
            primitiveTimerProbe.probeAndReset("retrieved graphics", 2);
            try {
                graphics2D.setColor(this.BGCOLOR);
                graphics2D.fillRect(0, 0, 1000, 1000);
                primitiveTimerProbe.probeAndReset("filled", 2);
            }
            finally {
                graphics2D.dispose();
                primitiveTimerProbe.probeAndReset("disposed", 2);
            }
            this.hasVirginBuffers = true;
            primitiveTimerProbe.probeAndReset("done", 2);
        }
    }

    private boolean needUpdateForSizeChange() {
        if (this.dimensionForTransform == null && this.isDisplayable()) {
            return true;
        }
        if (this.dimensionForTransform == null) {
            return false;
        }
        return this.dimensionForTransform.getWidth() != (double)this.getWidth() || this.dimensionForTransform.getHeight() != (double)this.getHeight();
    }

    protected void updateForSizeChange() {
        logger.debug("update for size change...");
        this.dimensionForTransform = new Dimension(this.getWidth(), this.getHeight());
        this.updateTransformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateTransformation() {
        Graphics2D graphics2D = (Graphics2D)super.getGraphics();
        if (graphics2D == null) {
            return;
        }
        try {
            logger.debug("updating transformation");
            this.canvasTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = 1000;
            int n4 = 1000;
            double d = (double)n / 1000.0;
            double d2 = (double)n2 / 1000.0;
            if (n > n2) {
                d *= (double)n2 / (double)n;
                n3 = (int)((double)n3 / ((double)n2 / (double)n));
            } else {
                d2 *= (double)n / (double)n2;
                n4 = (int)((double)n4 / ((double)n / (double)n2));
            }
            this.canvasTransform.concatenate(AffineTransform.getScaleInstance(d, -d2));
            this.canvasTransform.concatenate(AffineTransform.getTranslateInstance(n3 / 2, -n4 / 2));
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public void doLayout() {
        logger.debug("doLayout...");
        super.doLayout();
        if (this.needUpdateForSizeChange()) {
            this.updateForSizeChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (logger.isDebugEnabled()) {
            logger.debug("paint(): x=" + n + " y=" + n2 + " width=" + n3 + " height=" + n4);
        }
        if (this.needUpdateForSizeChange()) {
            this.updateForSizeChange();
        }
        Object object = this.renderLock;
        synchronized (object) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.setPaintMode();
                graphics2D.setClip(0, 0, n3, n4);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, n3, n4);
                graphics2D.transform(this.canvasTransform);
                if (this.stayingBackBuffer != null) {
                    graphics2D.drawImage((Image)this.stayingBackBuffer, -500, -500, null);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("stayingBackBuffer==null");
                }
                if (this.volatileBackBuffer != null) {
                    graphics2D.drawImage((Image)this.volatileBackBuffer, -500, -500, null);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("volatileBackBuffer==null");
                }
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareRender() {
        logger.debug("preparing render...");
        Object object = this.renderLock;
        synchronized (object) {
            this.createNewBackBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRender() {
        logger.debug("resetting render...");
        Object object = this.renderLock;
        synchronized (object) {
            this.createNewBackBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRender() {
        logger.debug("stopping render...");
        Object object = this.renderLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(List<Drawable> list) {
        logger.debug("rendering (and repaint'ing)...");
        Object object = this.renderLock;
        synchronized (object) {
            this.renderImpl(list);
        }
        this.repaint(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderImpl(List<Drawable> list) {
        if (this.stayingBackBuffer == null || this.volatileBackBuffer == null) {
            logger.error("no backbuffers have been created!");
            return;
        }
        if (this.hasVirginBuffers) {
            this.hasVirginBuffers = false;
            for (Drawable object2 : list) {
                object2.drawReset();
            }
        }
        Graphics2D graphics2D = this.stayingBackBuffer.createGraphics();
        try {
            if (AppModel.getInstance().getAntialiasing()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics2D.translate(500, 500);
            for (Drawable drawable : list) {
                if (logger.isDebugEnabled()) {
                    logger.debug("drawStayingParts: #=" + drawable);
                }
                drawable.drawStayingParts(graphics2D);
            }
        }
        finally {
            graphics2D.dispose();
        }
        this.stayingBackBuffer.copyData(this.volatileBackBuffer.getRaster());
        Graphics2D graphics2D2 = this.volatileBackBuffer.createGraphics();
        try {
            if (AppModel.getInstance().getAntialiasing()) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics2D2.translate(500, 500);
            for (Drawable drawable : list) {
                if (logger.isDebugEnabled()) {
                    logger.debug("drawVolatileParts: #=" + drawable);
                }
                drawable.drawVolatileParts(graphics2D2);
            }
        }
        finally {
            graphics2D2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformToCanvasSpace(int[] nArray) {
        double[] dArray = new double[]{nArray[0], nArray[1]};
        double[] dArray2 = new double[]{0.0, 0.0};
        try {
            SpiromatCanvas spiromatCanvas = this;
            synchronized (spiromatCanvas) {
                this.canvasTransform.inverseTransform(dArray, 0, dArray2, 0, 1);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            dArray2 = new double[]{0.0, 0.0};
        }
        nArray[0] = (int)dArray2[0];
        nArray[1] = (int)dArray2[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        logger.debug("clearing (its a no-op!?)...");
        Object object = this.renderLock;
        synchronized (object) {
            this.createNewBackBuffers();
        }
    }

    public Component getCanvasComponent() {
        return this;
    }
}

