/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderEdit
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JSpinner textField;
    protected JLabel label;
    protected JSlider slider;
    Action action;
    PropertyChangeListener actionPropChange;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public SliderEdit(String string, int n, int n2) {
        this.actionPropChange = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SliderEdit.this.actionPropertyChange(propertyChangeEvent);
            }
        };
        this.init(string, n, n2);
    }

    public SliderEdit(Action action, int n, int n2) {
        this("", n, n2);
        this.setAction(action);
    }

    private void init(String string, int n, int n2) {
        FormLayout formLayout = new FormLayout("0px, min(p;60dlu):grow, 5px, 24dlu, 0px", "0px, p, 5px, 12dlu, 0px");
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout(formLayout);
        this.label = new JLabel(string);
        this.add((Component)this.label, cellConstraints.xywh(2, 2, 3, 1));
        this.textField = new JSpinner(new SpinnerNumberModel(n, n, n2, 1));
        this.add((Component)this.textField, cellConstraints.xy(4, 4, CellConstraints.FILL, CellConstraints.FILL));
        this.slider = new JSlider(0);
        this.add((Component)this.slider, cellConstraints.xy(2, 4, CellConstraints.FILL, CellConstraints.FILL));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.slider.setMinimum(n);
        this.slider.setMaximum(n2);
        this.slider.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SliderEdit.this.textField.setValue(new Integer(SliderEdit.this.slider.getValue()));
                SliderEdit.this.fireValueChange(-1, SliderEdit.this.slider.getValue());
            }
        });
        this.textField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)SliderEdit.this.textField.getValue();
                SliderEdit.this.setValue(n);
            }
        });
        this.textField.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                SliderEdit.this.setValue(SliderEdit.this.slider.getValue() - n);
            }
        });
    }

    public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    void fireValueChange(int n, int n2) {
        this.pcs.firePropertyChange("VALUE", n, n2);
        if (this.action == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 2000, "VALUE");
        Integer n3 = new Integer(n2);
        this.action.putValue("INTEGER_VALUE", n3);
        this.action.actionPerformed(actionEvent);
    }

    public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAction(Action action) {
        Object object;
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionPropChange);
        }
        this.action = action;
        if (this.action == null) {
            return;
        }
        Object object2 = null;
        object2 = this.action.getValue("Name");
        if (object2 != null) {
            this.label.setText((String)object2);
        }
        if ((object2 = this.action.getValue("ShortDescription")) != null) {
            object = (String)object2;
            super.setToolTipText((String)object);
            this.textField.setToolTipText((String)object);
            this.label.setToolTipText((String)object);
            this.slider.setToolTipText((String)object);
        }
        if ((object2 = this.action.getValue("SmallIcon")) != null) {
            object = (Icon)object2;
            this.label.setIcon((Icon)object);
        }
        this.action.addPropertyChangeListener(this.actionPropChange);
    }

    protected void actionPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            if (string.equals("Name")) {
                this.label.setText((String)this.action.getValue("Name"));
            } else if (string.equals("SmallIcon")) {
                this.label.setIcon((Icon)this.action.getValue("SmallIcon"));
            } else if (string.equals("ShortDescription")) {
                String string2 = (String)this.action.getValue("ShortDescription");
                super.setToolTipText(string2);
                this.textField.setToolTipText(string2);
                this.label.setToolTipText(string2);
                this.slider.setToolTipText(string2);
            } else if (string.equals("enabled")) {
                this.setEnabled(this.action.isEnabled());
            }
        }
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        this.slider.setValue(n);
        this.textField.setValue(new Integer(n));
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.label.setEnabled(bl);
        this.slider.setEnabled(bl);
    }

    public void setLabelIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.textField.setToolTipText(string);
        this.label.setToolTipText(string);
        this.slider.setToolTipText(string);
    }
}

