/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class MessageLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    Color normalColor;
    Color warningColor;
    Color infoColor;
    String defaultText;
    private Timer timer;
    private TimerTask timerTask;
    Runnable runnable;

    public MessageLabel(String string) {
        super(string);
        this.defaultText = string;
        this.normalColor = this.getForeground();
        this.warningColor = Color.RED;
        this.infoColor = Color.decode("0x008000");
        this.runnable = new Runnable(){

            @Override
            public void run() {
                MessageLabel.this.setText(MessageLabel.this.defaultText);
                MessageLabel.this.setForeground(MessageLabel.this.normalColor);
            }
        };
        this.timer = new Timer("message-timer", true);
    }

    public void warning(String string) {
        this.setText(string);
        this.setForeground(this.warningColor);
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timer.purge();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(MessageLabel.this.runnable);
            }
        };
        this.timer.schedule(this.timerTask, 5000L);
    }

    public void info(String string) {
        this.setText(string);
        this.setForeground(this.infoColor);
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timer.purge();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(MessageLabel.this.runnable);
            }
        };
        this.timer.schedule(this.timerTask, 5000L);
    }
}

