/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.machines.AbstractMachine;
import de.admadic.spiromat.machines.Machine;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.ui.ControlPanel;
import de.admadic.spiromat.ui.FramedPanel;
import de.admadic.spiromat.ui.MessageLabel;
import de.admadic.spiromat.ui.Messages;
import de.admadic.spiromat.ui.Messenger;
import de.admadic.spiromat.ui.SpiromatCanvas;
import de.admadic.spiromat.ui.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainView
extends FramedPanel {
    private static final long serialVersionUID = 1L;
    static final Logger logger = Logger.getLogger(MainView.class);
    protected AppModel model;
    protected AbstractMachine machine;
    private JPanel borderNorth;
    private JPanel borderEast;
    private JPanel borderSouth;
    private ControlPanel controlPanel;
    private FramedPanel canvasFrame;
    private SpiromatCanvas canvas;
    private boolean lastPauseState;
    JLabel headlineLabel;
    ImageIcon imgHeadline;
    MessageLabel messageLabel;

    public MainView(AppModel appModel) {
        this.model = appModel;
        this.setFrameImage(Util.loadImage("spiromat-frame.png").getImage(), 5, 50);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.imgHeadline = Util.loadImage("headline.png");
        this.headlineLabel = new JLabel("");
        this.headlineLabel.setIcon(this.imgHeadline);
        this.headlineLabel.setAlignmentX(0.5f);
        this.messageLabel = new MessageLabel(Messages.getString("MainView.labelCoopyright"));
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(3, 12, 3, 12));
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(12.0f));
        Messenger.getInstance().registerMessageLabel(this.messageLabel);
        this.borderNorth = new JPanel();
        this.borderEast = new JPanel();
        this.borderSouth = new JPanel();
        this.borderNorth.setLayout(new BorderLayout());
        this.borderNorth.add((Component)this.headlineLabel, "After");
        this.borderSouth.setLayout(new BorderLayout());
        this.borderSouth.add((Component)this.messageLabel, "Center");
        this.setBackground(Color.LIGHT_GRAY);
        int n = 20;
        this.borderNorth.setSize(n, n);
        this.borderEast.setSize(n, n);
        this.borderSouth.setSize(n, n);
        this.borderNorth.setBackground(Color.WHITE);
        this.borderNorth.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.decode("0x339933")));
        this.borderSouth.setBackground(Color.WHITE);
        this.borderSouth.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.decode("0x0066cc")));
        this.add((Component)this.borderNorth, "North");
        this.add((Component)this.borderEast, "East");
        this.add((Component)this.borderSouth, "South");
        this.canvasFrame = new FramedPanel();
        this.canvasFrame.setFrameImage(Util.loadImage("canvas-frame2-exp.png").getImage(), 20, 100);
        this.canvas = new SpiromatCanvas();
        this.canvasFrame.add(this.canvas);
        this.add((Component)this.canvasFrame, "Center");
        this.controlPanel = new ControlPanel(appModel, null);
        this.add((Component)this.controlPanel, "West");
        this.replaceMachine(new Machine(this.canvas));
    }

    protected void replaceMachine(AbstractMachine abstractMachine) {
        if (this.machine != null) {
            this.machine.stopMachine();
            this.machine.detachFromModel();
            this.machine.destroyMachine();
        }
        this.machine = abstractMachine;
        if (this.machine != null) {
            this.machine.attachToModel();
        }
    }

    public SpiromatCanvas getSpiromatCanvas() {
        return this.canvas;
    }

    public void destroy() {
        this.machine.destroyMachine();
    }

    public void init() {
    }

    public void start() {
        this.model.setPause(this.lastPauseState);
    }

    public void stop() {
        this.lastPauseState = this.model.getPause();
        this.model.setPause(true);
    }
}

