/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import de.admadic.spiromat.actions.ActionFactory;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.machines.AbstractMachine;
import de.admadic.spiromat.machines.Machine;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.ModelPropertyChangeListener;
import de.admadic.spiromat.model.ModelPropertyChangeSupport;
import de.admadic.spiromat.ui.BackgroundStatus;
import de.admadic.spiromat.ui.ControlPanel;
import de.admadic.spiromat.ui.DocPanel;
import de.admadic.spiromat.ui.FileChooserProvider;
import de.admadic.spiromat.ui.FramedPanel;
import de.admadic.spiromat.ui.MessageLabel;
import de.admadic.spiromat.ui.Messages;
import de.admadic.spiromat.ui.Messenger;
import de.admadic.spiromat.ui.SpiromatCanvas;
import de.admadic.spiromat.ui.StatusLine;
import de.admadic.spiromat.ui.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class MainFrame
extends JFrame
implements ModelPropertyChangeListener {
    private static final long serialVersionUID = 1L;
    static final Logger logger = Logger.getLogger(MainFrame.class);
    protected AppModel appModel;
    protected AbstractMachine machine;
    private JSplitPane splitMain;
    private JPanel borderNorth;
    private JPanel borderSouth;
    private JToolBar toolBar;
    private ControlPanel controlPanel;
    private FramedPanel canvasFrame;
    private SpiromatCanvas canvas;
    private DocPanel docPanel;
    private BackgroundStatus backgroundStatus;
    private StatusLine statusLine;
    private boolean lastPauseState;
    JLabel headlineLabel;
    ImageIcon imgHeadline;
    MessageLabel messageLabel;
    ModelPropertyChangeSupport modelPropertyChangeSupport;

    public MainFrame(AppModel appModel) {
        this.appModel = appModel;
    }

    @Override
    public void appPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void docPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("docModelDirty")) {
            logger.debug("dirty change detected");
            this.updateTitle();
        }
    }

    @Override
    public void figPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void initContents() {
        this.modelPropertyChangeSupport = new ModelPropertyChangeSupport(3, this, true);
        ActionFactory.get("newDoc").actionPerformed(new ActionEvent(this, 1001, "init"));
        this.updateTitle();
        this.setIconImages(Util.loadLogoImages());
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ActionFactory.get("close").actionPerformed(ActionFactory.createEvent(MainFrame.this, "quit"));
            }
        });
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.imgHeadline = Util.loadImage("headline.png");
        this.headlineLabel = new JLabel(this.imgHeadline);
        this.headlineLabel.setAlignmentX(0.5f);
        this.messageLabel = new MessageLabel(Messages.getString("MainFrame.labelCopyright"));
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(3, 12, 3, 12));
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(12.0f));
        Messenger.getInstance().registerMessageLabel(this.messageLabel);
        this.toolBar = new JToolBar(1);
        this.toolBar.setBorderPainted(true);
        this.toolBar.setBackground(UIManager.getColor("Panel.background"));
        this.toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 1, 3, 3), BorderFactory.createMatteBorder(0, 1, 0, 0, Color.decode("0x339933"))));
        this.borderNorth = new JPanel();
        this.borderNorth.setLayout(new BorderLayout());
        this.borderNorth.add((Component)this.headlineLabel, "After");
        this.borderNorth.setBackground(Color.WHITE);
        this.borderNorth.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.decode("0x339933")));
        this.backgroundStatus = new BackgroundStatus();
        this.statusLine = new StatusLine();
        this.statusLine.addComponent(this.messageLabel, null);
        this.statusLine.addComponent(this.backgroundStatus, "20dlu");
        this.borderSouth = new JPanel();
        this.borderSouth.setLayout(new BorderLayout());
        this.borderSouth.add((Component)this.statusLine, "Center");
        this.borderSouth.setBackground(Color.WHITE);
        this.borderSouth.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.decode("0x0066cc")));
        this.toolBar.addSeparator();
        this.toolBar.add(new JToggleButton(ActionFactory.get("showPicture")));
        this.toolBar.addSeparator();
        this.toolBar.add(ActionFactory.get("newDoc"));
        this.toolBar.addSeparator();
        this.toolBar.add(ActionFactory.get("openDoc"));
        this.toolBar.addSeparator();
        this.toolBar.add(ActionFactory.get("saveDoc"));
        this.toolBar.addSeparator();
        this.toolBar.add(ActionFactory.get("saveAsDoc"));
        this.toolBar.addSeparator();
        this.toolBar.add(ActionFactory.get("exportDoc"));
        this.toolBar.addSeparator();
        this.toolBar.add(ActionFactory.get("about"));
        this.toolBar.addSeparator();
        this.toolBar.add(ActionFactory.get("close"));
        this.toolBar.setFloatable(false);
        this.add((Component)this.borderNorth, "North");
        this.add((Component)this.borderSouth, "South");
        this.add((Component)this.toolBar, "East");
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            Component component = this.toolBar.getComponent(i);
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setHideActionText(true);
        }
        this.splitMain = new JSplitPane(1, false);
        this.splitMain.setBorder(null);
        this.add((Component)this.splitMain, "Center");
        this.canvasFrame = new FramedPanel();
        this.canvasFrame.setFrameImage(Util.loadImage("canvas-frame2-exp.png").getImage(), 20, 100);
        this.canvas = new SpiromatCanvas();
        this.canvasFrame.add(this.canvas);
        this.splitMain.setRightComponent(this.canvasFrame);
        this.docPanel = new DocPanel();
        this.controlPanel = new ControlPanel(this.appModel, this.docPanel);
        this.splitMain.setLeftComponent(this.controlPanel);
        this.replaceMachine(new Machine(this.canvas));
        this.setSize(700, 550);
        this.setLocationRelativeTo(null);
        FileChooserProvider.prepareInBackground();
    }

    protected void updateTitle() {
        Object object;
        boolean bl = false;
        Integer n = null;
        String string = "<untitled>";
        String string2 = "";
        if (AppModel.getInstance() != null && AppModel.getInstance().getDocModel() != null) {
            object = AppModel.getInstance().getDocModel();
            bl = ((DocModel)object).isDirty();
            File file = ((DocModel)object).getFile();
            if (file != null) {
                string = file.getName();
                if (file.getParent() != null) {
                    string2 = file.getParent();
                }
            }
        }
        n = bl ? 1 : 0;
        object = MessageFormat.format(Messages.getString("MainFrame.titleFormat"), n, string, string2.length(), string2);
        this.setTitle((String)object);
    }

    protected void replaceMachine(AbstractMachine abstractMachine) {
        if (this.machine != null) {
            this.machine.stopMachine();
            this.machine.detachFromModel();
            this.machine.destroyMachine();
        }
        this.machine = abstractMachine;
        if (this.machine != null) {
            this.machine.attachToModel();
        }
    }

    public SpiromatCanvas getSpiromatCanvas() {
        return this.canvas;
    }

    public void destroy() {
        this.machine.destroyMachine();
    }

    public void init() {
    }

    public void start() {
        this.appModel.setPause(this.lastPauseState);
    }

    public void stop() {
        this.lastPauseState = this.appModel.getPause();
        this.appModel.setPause(true);
    }
}

