/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.ui.Messages;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public class FileChooserProvider {
    static Logger logger = Logger.getLogger(FileChooserProvider.class);
    static Object fcLock = new Object();
    static JFileChooser theFileChooser = null;
    static Thread thread;
    static boolean prepareStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareInBackground() {
        logger.trace("prepare started");
        Object object = fcLock;
        synchronized (object) {
            if (prepareStarted) {
                return;
            }
            prepareStarted = true;
            logger.trace("prepare started for sure");
        }
        thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    logger.trace("thread: creating new JFileChooser");
                    JFileChooser jFileChooser = new JFileChooser();
                    logger.trace("thread: done.");
                    if (Thread.currentThread().isInterrupted()) {
                        logger.trace("thread: interrupted!");
                        return;
                    }
                    Object object = fcLock;
                    synchronized (object) {
                        logger.trace("thread: storing the instance and notifying");
                        theFileChooser = jFileChooser;
                        fcLock.notifyAll();
                    }
                }
                finally {
                    logger.trace("thread: cleaning thread field");
                    thread = null;
                }
            }
        }, "JFileChooser loader");
        thread.setDaemon(true);
        thread.start();
    }

    public static JFileChooser getFileChooser() {
        if (theFileChooser == null) {
            logger.trace("auto creating...");
            FileChooserProvider.createFileChooser();
        }
        return theFileChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileChooser() {
        logger.trace("creating new JFileChooser");
        if (theFileChooser != null) {
            logger.trace("an instance is already there - bailing out...");
            return;
        }
        Object object = fcLock;
        synchronized (object) {
            if (!prepareStarted) {
                logger.trace("not yet prepared, calling prepare...");
                FileChooserProvider.prepareInBackground();
            }
            if (theFileChooser != null) {
                logger.trace("filechooser already there, don't need waiting...");
                return;
            }
            logger.trace("waiting for the instance.");
            while (theFileChooser == null) {
                try {
                    logger.trace("wait()");
                    fcLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    logger.trace("error waiting", interruptedException);
                    interruptedException.printStackTrace();
                    return;
                }
            }
            logger.trace("ok. we have an instance now...");
        }
    }

    public static void setSpmFilter(JFileChooser jFileChooser) {
        FileFilter[] fileFilterArray;
        for (FileFilter fileFilter : fileFilterArray = jFileChooser.getChoosableFileFilters()) {
            jFileChooser.removeChoosableFileFilter(fileFilter);
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new GenericFilter(".spm", Messages.getString("FileChooserProvider.fileDescSpm")));
    }

    public static void setExportsFilter(JFileChooser jFileChooser) {
        FileFilter[] fileFilterArray;
        for (FileFilter fileFilter : fileFilterArray = jFileChooser.getChoosableFileFilters()) {
            jFileChooser.removeChoosableFileFilter(fileFilter);
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new GenericFilter(".png", Messages.getString("FileChooserProvider.fileDescPng")));
        jFileChooser.addChoosableFileFilter(new GenericFilter(".jpg", Messages.getString("FileChooserProvider.fileDescJpg")));
        jFileChooser.addChoosableFileFilter(new GenericFilter(".svg", Messages.getString("FileChooserProvider.fileDescSvg")));
    }

    public static File fixupExtension(JFileChooser jFileChooser, File file) {
        String string = file.getName();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return file;
        }
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (!(fileFilter instanceof GenericFilter)) {
            return file;
        }
        GenericFilter genericFilter = (GenericFilter)fileFilter;
        String string2 = genericFilter.getExtension().toLowerCase();
        if (file.getName().endsWith(string2)) {
            return file;
        }
        return new File(file.getParentFile(), file.getName() + string2);
    }

    static {
        prepareStarted = false;
    }

    static class GenericFilter
    extends FileFilter {
        SuffixFileFilter ff;
        String extension;
        String description;

        public GenericFilter(String string, String string2) {
            this.extension = string;
            this.description = string2;
            this.ff = new SuffixFileFilter(this.extension);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return this.ff.accept(file);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

