/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.spiromat.actions.ActionFactory;
import de.admadic.spiromat.actions.MoveFigureDownAction;
import de.admadic.spiromat.actions.MoveFigureUpAction;
import de.admadic.spiromat.actions.RemoveFigureAction;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.ModelPropertyChangeListener;
import de.admadic.spiromat.model.ModelPropertyChangeSupport;
import de.admadic.spiromat.ui.ColorCellEditor;
import de.admadic.spiromat.ui.ColorCellRenderer;
import de.admadic.spiromat.ui.FigureSpecTableCellRenderer;
import de.admadic.spiromat.ui.Messages;
import de.admadic.spiromat.ui.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class DocPanel
extends JPanel
implements ModelPropertyChangeListener {
    static Logger logger = Logger.getLogger(DocPanel.class);
    private static final long serialVersionUID = 1L;
    DocModel docModel;
    private JLabel figuresLabel;
    FigureTableModel figureTableModel;
    JTable figureTable;
    private JScrollPane figureScroller;
    private JButton btnAddFigure;
    private JButton btnRemoveFigure;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    ModelPropertyChangeSupport modelPropSupport = new ModelPropertyChangeSupport(-1, this, false);

    public DocPanel() {
        UIManager.getDefaults().put("Table.font", UIManager.getFont("Table.font").deriveFont(14.0f));
        FormLayout formLayout = new FormLayout("0px, d:grow(0.25), 5px, d:grow(0.25), 5px, d:grow(0.25), 5px, d:grow(0.25), 0px", "0px, d, 5px, d, 5px, d:grow, 0px");
        formLayout.setColumnGroups(new int[][]{{2, 4, 6, 8}});
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.figuresLabel = new JLabel("Figures:");
        this.figureTableModel = new FigureTableModel();
        this.figureTable = new JTable(this.figureTableModel);
        this.figureTable.setAutoResizeMode(4);
        this.figureTable.setShowVerticalLines(false);
        this.figureTable.setDefaultRenderer(Color.class, new ColorCellRenderer());
        this.figureTable.setDefaultRenderer(FigureSpec.class, new FigureSpecTableCellRenderer());
        this.figureTable.setDefaultEditor(Color.class, new ColorCellEditor());
        HeaderRenderer headerRenderer = new HeaderRenderer();
        this.figureTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.figureTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.figureTable.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.figureTable.getColumnModel().getColumn(0).setHeaderRenderer(headerRenderer);
        this.figureTable.getColumnModel().getColumn(1).setHeaderRenderer(headerRenderer);
        this.figureTable.getColumnModel().getColumn(2).setHeaderRenderer(headerRenderer);
        this.figureTable.setSelectionMode(0);
        this.figureTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = DocPanel.this.figureTable.getSelectedRow();
                if (n == DocPanel.this.docModel.getActiveFigureIndex()) {
                    return;
                }
                DocPanel.this.docModel.setActiveFigureIndex(n);
            }
        });
        this.figureScroller = new JScrollPane(this.figureTable, 22, 30);
        this.figuresLabel.setLabelFor(this.figureTable);
        this.add((Component)this.figuresLabel, cellConstraints.xywh(2, 2, 7, 1));
        this.btnAddFigure = Util.createJButton(ActionFactory.get("addFigure"));
        this.add((Component)this.btnAddFigure, cellConstraints.xy(2, 4));
        this.btnRemoveFigure = Util.createJButton(ActionFactory.get("removeFigure"));
        this.add((Component)this.btnRemoveFigure, cellConstraints.xy(4, 4));
        this.btnMoveUp = Util.createJButton(ActionFactory.get("moveFigureUp"));
        this.add((Component)this.btnMoveUp, cellConstraints.xy(6, 4));
        this.btnMoveDown = Util.createJButton(ActionFactory.get("moveFigureDown"));
        this.add((Component)this.btnMoveDown, cellConstraints.xy(8, 4));
        this.add((Component)this.figureScroller, cellConstraints.xywh(2, 6, 7, 1, CellConstraints.FILL, CellConstraints.FILL));
        ((MoveFigureUpAction)ActionFactory.get("moveFigureUp")).setListModelRef(this.figureTable.getSelectionModel());
        ((MoveFigureDownAction)ActionFactory.get("moveFigureDown")).setListModelRef(this.figureTable.getSelectionModel());
        ((RemoveFigureAction)ActionFactory.get("removeFigure")).setListModelRef(this.figureTable.getSelectionModel());
        this.figureScroller.setPreferredSize(new Dimension(150, 100));
        this.docModel = AppModel.getInstance().getDocModel();
        this.updateDataModel();
        logger.debug("attaching modelPropSupport");
        this.modelPropSupport.attachToAppModel();
    }

    protected void updateFigModel() {
        int n = this.docModel.getActiveFigureIndex();
        if (n < 0) {
            return;
        }
        this.figureTableModel.fireTableRowsUpdated(n, n);
    }

    protected void updateDataModel() {
        this.figureTableModel.setFigureSpecsRef(this.docModel.getFigureListReference());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.figureTable.setEnabled(bl);
    }

    @Override
    public void appPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("docModel")) {
            logger.debug("detected docModel change -> updating data model");
            this.docModel = AppModel.getInstance().getDocModel();
            this.updateDataModel();
        }
    }

    @Override
    public void docPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            if (string.equals("figureList")) {
                this.updateDataModel();
            } else if (string.equals("figureListContent")) {
                this.figureTableModel.fireTableRowsUpdated(0, this.figureTableModel.getRowCount() - 1);
            } else if (string.equals("activeFigure")) {
                this.figureTableModel.fireTableRowsUpdated(0, this.figureTableModel.getRowCount() - 1);
            }
        }
    }

    @Override
    public void figPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && (string.equals("outerRadius") || string.equals("innerRadius") || string.equals("penHolePos") || string.equals("color"))) {
            this.updateFigModel();
        }
    }

    static class HeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        Color fgcolor = UIManager.getColor("TableHeader.foreground");
        Color bgcolor = UIManager.getColor("TableHeader.background");

        HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            JLabel jLabel = (JLabel)component;
            jLabel.setBackground(this.bgcolor);
            jLabel.setForeground(this.fgcolor);
            return component;
        }
    }

    static class FigureTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private WeakReference<ArrayList<FigureSpec>> figureSpecsRef;
        private String[] columnNames = new String[]{Messages.getString("DocPanel.tableHeadingActive"), Messages.getString("DocPanel.tableHeadingParams"), Messages.getString("DocPanel.tableHeadingColor")};
        private Class<?>[] columnClasses = new Class[]{Boolean.class, FigureSpec.class, Color.class};
        private boolean[] columnEditables = new boolean[]{false, false, true};

        public FigureTableModel() {
            this.figureSpecsRef = new WeakReference<Object>(null);
        }

        public WeakReference<ArrayList<FigureSpec>> getFigureSpecsRef() {
            return this.figureSpecsRef;
        }

        public ArrayList<FigureSpec> getFigureSpecs() {
            return (ArrayList)this.figureSpecsRef.get();
        }

        public void setFigureSpecsRef(WeakReference<ArrayList<FigureSpec>> weakReference) {
            logger.debug("setting new figure list in table model");
            this.figureSpecsRef = weakReference;
            ArrayList arrayList = (ArrayList)weakReference.get();
            if (arrayList != null) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            ArrayList<FigureSpec> arrayList = this.getFigureSpecs();
            return arrayList == null ? 0 : arrayList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ArrayList<FigureSpec> arrayList = this.getFigureSpecs();
            if (arrayList == null) {
                return null;
            }
            FigureSpec figureSpec = arrayList.get(n);
            switch (n2) {
                case 0: {
                    return figureSpec.isActive();
                }
                case 1: {
                    return figureSpec;
                }
                case 2: {
                    return figureSpec.getColor();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.columnClasses[n];
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0 && n == AppModel.getInstance().getDocModel().getActiveFigureIndex()) {
                return false;
            }
            return this.columnEditables[n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ArrayList<FigureSpec> arrayList = this.getFigureSpecs();
            if (arrayList == null) {
                return;
            }
            FigureSpec figureSpec = arrayList.get(n);
            switch (n2) {
                case 0: {
                    if (figureSpec.isActive()) break;
                    AppModel.getInstance().getDocModel().setActiveFigureIndex(n);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    figureSpec.setColor((Color)object);
                }
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

