/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.spiromat.SpiromatException;
import de.admadic.spiromat.actions.ActionFactory;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.ModelPropertyChangeListener;
import de.admadic.spiromat.model.ModelPropertyChangeSupport;
import de.admadic.spiromat.ui.DocPanel;
import de.admadic.spiromat.ui.EnabledProxyFactory;
import de.admadic.spiromat.ui.IEnabledProxy;
import de.admadic.spiromat.ui.Messages;
import de.admadic.spiromat.ui.SliderEdit;
import de.admadic.spiromat.ui.Util;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class ControlPanel
extends JPanel
implements ModelPropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = Logger.getLogger(ControlPanel.class);
    protected AppModel appModel;
    private DocPanel docPanel;
    JToggleButton btn_animated;
    JToggleButton btn_mouseControlled;
    JToggleButton btn_instantUpdate;
    JButton btn_clear;
    JButton btn_fill;
    SliderEdit sld_innerRadius;
    SliderEdit sld_outerRadius;
    SliderEdit sld_lambda;
    JButton btn_start;
    JButton btn_pause;
    JToggleButton btn_showGears;
    JToggleButton btn_showFigure;
    JToggleButton btn_showPicture;
    JToggleButton btn_autoFill;
    HashMap<IEnabledProxy, Boolean> instantMap;
    HashMap<IEnabledProxy, Boolean> mouseMap;
    HashMap<IEnabledProxy, Boolean> animatedMap;
    HashMap<IEnabledProxy, Boolean> previewMap;
    ModelPropertyChangeSupport modelPropChange = new ModelPropertyChangeSupport(this);

    public ControlPanel(AppModel appModel, DocPanel docPanel) {
        this.appModel = appModel;
        this.docPanel = docPanel;
        UIManager.getDefaults().put("ToolTip.font", UIManager.getFont("ToolTip.font").deriveFont(14.0f));
        this.createContents();
        this.initMaps();
        this.updateContentsValues();
        this.linkContents();
    }

    private void initMaps() {
        this.instantMap = new HashMap();
        this.mouseMap = new HashMap();
        this.animatedMap = new HashMap();
        this.previewMap = new HashMap();
        Object[] objectArray = new Object[]{"outerGearValue", "YNNN", "innerGearValue", "YNNN", "penHolePosValue", "YNNN", "showGears", "YNNN", "showFigure", "YNNN", "animate", "YNYN", "mouseControlled", "YYNN", "fill", "YNNN", "clear", "YNNN", "autoFill", "YNNN", "showPicture", "YNNY", "addFigure", "YNNY", "removeFigure", "YNNY", "moveFigureUp", "YNNY", "moveFigureDown", "YNNY", "newDoc", "YNNY", "openDoc", "YNNY", "saveDoc", "YNNY", "saveAsDoc", "YNNY", "exportDoc", "YNNY", this.docPanel, "YNNY"};
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object;
            IEnabledProxy iEnabledProxy = null;
            if (objectArray[i + 0] instanceof String) {
                object = ActionFactory.get((String)objectArray[i + 0]);
                iEnabledProxy = EnabledProxyFactory.wrap((Action)object);
            } else if (objectArray[i + 0] instanceof JComponent) {
                object = (JComponent)objectArray[i + 0];
                iEnabledProxy = EnabledProxyFactory.wrap((JComponent)object);
            } else {
                throw new SpiromatException("invalid enabled map key type");
            }
            object = (String)objectArray[i + 1];
            this.instantMap.put(iEnabledProxy, ((String)object).charAt(0) == 'Y' ? Boolean.TRUE : Boolean.FALSE);
            this.mouseMap.put(iEnabledProxy, ((String)object).charAt(1) == 'Y' ? Boolean.TRUE : Boolean.FALSE);
            this.animatedMap.put(iEnabledProxy, ((String)object).charAt(2) == 'Y' ? Boolean.TRUE : Boolean.FALSE);
            this.previewMap.put(iEnabledProxy, ((String)object).charAt(3) == 'Y' ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    void updateComponentStatus(HashMap<IEnabledProxy, Boolean> hashMap) {
        for (IEnabledProxy iEnabledProxy : hashMap.keySet()) {
            iEnabledProxy.setEnabled(hashMap.get(iEnabledProxy));
        }
    }

    private void createContents() {
        FormLayout formLayout = new FormLayout("12px, d:grow(0.33), 5px, d:grow(0.33), 5px, d:grow(0.33), 12px", "12px, d, 5px, d, 5px, d, 10px, d, 5px, d, 5px, d, 5px, " + (this.docPanel != null ? "d, 5px, d:grow, 5px" : ""));
        formLayout.setColumnGroups(new int[][]{{2, 4, 6}});
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.sld_outerRadius = new SliderEdit(ActionFactory.get("outerGearValue"), 4, 100);
        this.add((Component)this.sld_outerRadius, cellConstraints.xywh(2, 2, 5, 1));
        this.sld_innerRadius = new SliderEdit(ActionFactory.get("innerGearValue"), 4, 100);
        this.add((Component)this.sld_innerRadius, cellConstraints.xywh(2, 4, 5, 1));
        this.sld_lambda = new SliderEdit(ActionFactory.get("penHolePosValue"), 0, 100);
        this.add((Component)this.sld_lambda, cellConstraints.xywh(2, 6, 5, 1));
        this.btn_mouseControlled = Util.createJToggleButton(ActionFactory.get("mouseControlled"));
        this.add((Component)this.btn_mouseControlled, cellConstraints.xywh(2, 8, 1, 1));
        this.btn_animated = Util.createJToggleButton(ActionFactory.get("animate"));
        this.add((Component)this.btn_animated, cellConstraints.xywh(4, 8, 1, 1));
        this.btn_autoFill = Util.createJToggleButton(ActionFactory.get("autoFill"));
        this.add((Component)this.btn_autoFill, cellConstraints.xywh(6, 8, 1, 1));
        this.add((Component)new JLabel(Messages.getString("ControlPanel.labelDisplayOptions")), cellConstraints.xywh(2, 10, 5, 1));
        this.btn_showFigure = Util.createJToggleButton(ActionFactory.get("showFigure"));
        this.add((Component)this.btn_showFigure, cellConstraints.xywh(2, 12, 1, 1));
        this.btn_showGears = Util.createJToggleButton(ActionFactory.get("showGears"));
        this.add((Component)this.btn_showGears, cellConstraints.xywh(4, 12, 1, 1));
        this.btn_clear = Util.createJButton(ActionFactory.get("clear"));
        this.add((Component)this.btn_clear, cellConstraints.xywh(6, 12, 1, 1));
        if (this.docPanel != null) {
            this.add((Component)new JSeparator(0), cellConstraints.xywh(2, 14, 5, 1));
            this.add((Component)this.docPanel, cellConstraints.xywh(2, 16, 5, 1, CellConstraints.FILL, CellConstraints.FILL));
        }
        this.sld_innerRadius.setFont(this.sld_innerRadius.getFont().deriveFont(12.0f));
        this.sld_outerRadius.setFont(this.sld_outerRadius.getFont().deriveFont(12.0f));
        this.sld_lambda.setFont(this.sld_lambda.getFont().deriveFont(12.0f));
        this.sld_innerRadius.setToolTipText(Messages.getString("ControlPanel.toolTipInnerGear"));
        this.sld_outerRadius.setToolTipText(Messages.getString("ControlPanel.toolTipOuterGear"));
        this.sld_lambda.setToolTipText(Messages.getString("ControlPanel.toolTipPenHolePos"));
    }

    protected AppModel getModel() {
        return this.appModel;
    }

    private void linkContents() {
        this.getModel().addComponent("outerRadius", this.sld_outerRadius);
        this.getModel().addComponent("innerRadius", this.sld_innerRadius);
        this.getModel().addComponent("lambda", this.sld_lambda);
        this.getModel().addComponent("mouseControlled", this.btn_mouseControlled);
        this.getModel().addComponent("animated", this.btn_animated);
        this.getModel().addComponent("showGears", this.btn_showGears);
        this.getModel().addComponent("showFigure", this.btn_showFigure);
        this.getModel().addComponent("autoFill", this.btn_autoFill);
    }

    private void updateContentsValues() {
        this.sld_outerRadius.setValue(this.appModel.getOuterRadius());
        this.sld_innerRadius.setValue(this.appModel.getInnerRadius());
        this.sld_lambda.setValue((int)(this.appModel.getLambda() * 100.0));
        this.btn_showFigure.setSelected(this.appModel.getShowFigure());
        this.btn_showGears.setSelected(this.appModel.getShowGears());
        this.btn_autoFill.setSelected(this.appModel.getAutoFill());
    }

    @Override
    public void appPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("mouseControlled")) {
            if (this.getModel().getMouseControlled()) {
                logger.debug("turning buttons off");
                if (this.btn_start != null) {
                    this.btn_start.setEnabled(true);
                }
                if (this.btn_pause != null) {
                    this.btn_pause.setEnabled(false);
                }
                this.updateComponentStatus(this.mouseMap);
            }
        } else if (string.equals("animated")) {
            if (this.getModel().getAnimated()) {
                logger.debug("turning buttons on");
                if (this.btn_start != null) {
                    this.btn_start.setEnabled(true);
                }
                if (this.btn_pause != null) {
                    this.btn_pause.setEnabled(true);
                }
                this.updateComponentStatus(this.animatedMap);
            }
        } else if (string.equals("instantUpdate")) {
            if (this.getModel().getInstantUpdate()) {
                this.updateComponentStatus(this.instantMap);
            }
        } else if (string.equals("showPicture")) {
            if (this.getModel().getShowPicture()) {
                this.updateComponentStatus(this.previewMap);
            } else {
                this.updateComponentStatus(this.instantMap);
            }
        }
    }

    @Override
    public void docPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("activeFigure")) {
            this.updateParamsForFigureSpec(AppModel.getInstance().getDocModel().getActiveFigureSpec());
        }
    }

    private void updateParamsForFigureSpec(FigureSpec figureSpec) {
        if (figureSpec == null) {
            return;
        }
        DocModel docModel = AppModel.getInstance().getDocModel();
        docModel.setActiveFigureSpecLocked(true);
        this.sld_outerRadius.setValue(figureSpec.getOuterRadius());
        this.sld_innerRadius.setValue(figureSpec.getInnerRadius());
        this.sld_lambda.setValue((int)(figureSpec.getPenHolePos() * 100.0));
        docModel.setActiveFigureSpecLocked(false);
    }

    @Override
    public void figPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

