/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import de.admadic.cfg.Cfg;
import de.admadic.cfg.CfgPersistenceXML;
import de.admadic.spiromat.ui.Messages;
import de.admadic.util.FileUtil;
import de.admadic.util.PathManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JOptionPane;

public class CfgSpi
extends Cfg {
    static boolean DBG = false;
    public static final char ITEM_SEPARATOR = ':';
    public static final String ITEM_SEPARATOR_STR = ":";
    public static final String PREFERENCES_PATH = "/de.admadic.spiromat";
    public static final String KEY_UI_MAIN_LIC_NAME = "ui.main.lic.name";
    public static final String KEY_UI_MAIN_LIC_COMPANY = "ui.main.lic.company";
    public static final String KEY_UI_MAIN_LIC_SN = "ui.main.lic.sn";
    public static final String KEY_UI_SN_STAT_SN = "ui.sns.sn";
    Object[][] stdValues = new Object[][]{{"ui.main.lic.name", ""}, {"ui.main.lic.company", ""}, {"ui.main.lic.sn", ""}, {"ui.sns.sn", ""}};
    Properties props;
    String cfgPath;
    String cfgFile;
    String cfgFullName;

    public CfgSpi() {
        String string = System.getProperty("admadic.debug");
        if (string != null && string.toLowerCase().equals("yes")) {
            DBG = true;
        }
        this.props = new Properties();
    }

    protected void error(String string) {
        this.error(string, true);
    }

    protected void error(String string, boolean bl) {
        System.err.println("Spiromat: " + string);
        if (bl) {
            JOptionPane.showMessageDialog(null, string, Messages.getString("CfgSpi.configErrorTitle"), 0);
        }
    }

    public void initCfgPaths(PathManager pathManager) {
        File file = null;
        if (DBG) {
            System.out.println("CfgSpi: initCfgPaths");
        }
        try {
            file = new File(pathManager.getPathString(5) + "/cfg.cfg");
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.props.load(fileInputStream);
            } else {
                InputStream inputStream = this.getClass().getResourceAsStream("/de/admadic/spiromat/cfg/cfg.cfg");
                this.props.load(inputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (DBG) {
                fileNotFoundException.printStackTrace();
            }
            this.error("The main cfg file could not be found! (looking for cfg.cfg)\nsys-cfg-dir = " + pathManager.getPathString(5));
        }
        catch (IOException iOException) {
            if (DBG) {
                iOException.printStackTrace();
            }
            this.error("a cfg file exists, but could not be read! (" + (file != null ? file.toString() : "<null>") + ")");
        }
        this.cfgPath = this.props.getProperty("de.admadic.spiromat.ui.CfgSpi.cfgpath");
        this.cfgFile = this.props.getProperty("de.admadic.spiromat.ui.CfgSpi.cfgfile");
        if (this.cfgPath == null) {
            this.cfgPath = pathManager.getPathString(13);
        }
        file = PathManager.expandFilename(this.cfgPath);
        this.cfgPath = file.toString();
        file = new File(file, this.cfgFile);
        this.cfgFullName = file.toString();
    }

    public boolean existsCfgFile() {
        File file = new File(this.cfgFullName);
        return file.exists();
    }

    public boolean copyCfgFile(String string) {
        return FileUtil.copyTextFile(string, this.cfgFullName);
    }

    protected void tryPath() {
        File file = new File(this.cfgPath);
        if (!file.exists() && !file.mkdirs()) {
            this.error("Could not create cfg path (" + this.cfgPath + ")");
        }
    }

    public void initialize(boolean bl) {
        this.initStandard();
        this.registerPersistanceBackend(new CfgPersistenceXML(this, this.cfgFullName));
        if (bl) {
            this.loadPreferences(PREFERENCES_PATH);
        }
        this.postLoadFixup();
    }

    public static Cfg createTmpCfg(String string) {
        Cfg cfg = new Cfg();
        cfg.registerPersistanceBackend(new CfgPersistenceXML(cfg, string));
        return cfg;
    }

    public void initStandard() {
        for (int i = 0; i < this.stdValues.length; ++i) {
            if (this.stdValues[i].length != 2) {
                this.error("stdCfgEntry x[" + i + "] does not have 2 elements.", false);
                continue;
            }
            String string = (String)this.stdValues[i][0];
            this.getDefaultCfg().putValue(string, this.stdValues[i][1]);
        }
        this.getDefaultCfg().getCfgItem(KEY_UI_MAIN_LIC_NAME).setCiFlags(1, true);
        this.getDefaultCfg().getCfgItem(KEY_UI_MAIN_LIC_COMPANY).setCiFlags(1, true);
        this.getDefaultCfg().getCfgItem(KEY_UI_MAIN_LIC_SN).setCiFlags(1, true);
        this.getDefaultCfg().getCfgItem(KEY_UI_SN_STAT_SN).setCiFlags(1, true);
        this.setDefaults();
    }

    public void postLoadFixup() {
    }
}

