/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.spiromat.ui.BackgroundManager;
import de.admadic.spiromat.ui.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BackgroundWaitDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JLabel msgLabel;
    JLabel tskLabel;
    JButton cancel;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BackgroundWaitDialog.this.updateTaskCount((Integer)propertyChangeEvent.getNewValue());
        }
    };

    public BackgroundWaitDialog(Frame frame) {
        super(frame);
        this.init();
    }

    public BackgroundWaitDialog(Dialog dialog) {
        super(dialog);
        this.init();
    }

    public void setCancelEnabled(boolean bl) {
        this.cancel.setEnabled(bl);
    }

    public void execute() {
        this.setModal(true);
        BackgroundManager.getInstance().addPropertyChangeListener(this.pcl);
        int n = BackgroundManager.getInstance().getTaskCount();
        if (n > 0) {
            this.tskLabel.setText("" + n);
            this.setVisible(true);
        }
        BackgroundManager.getInstance().removePropertyChangeListener(this.pcl);
    }

    private void init() {
        this.setLayout(new FormLayout("12px, p, 12px", "12px, d, 5px, d, 12px, d, 12px"));
        CellConstraints cellConstraints = new CellConstraints();
        this.setTitle(Messages.getString("BackgroundWaitDialog.dialogTitle"));
        this.msgLabel = new JLabel(Messages.getString("BackgroundWaitDialog.waitMessage"));
        this.add((Component)this.msgLabel, cellConstraints.xy(2, 2, CellConstraints.FILL, CellConstraints.FILL));
        this.tskLabel = new JLabel("?");
        this.add((Component)this.tskLabel, cellConstraints.xy(2, 4, CellConstraints.FILL, CellConstraints.FILL));
        this.cancel = new JButton(Messages.getString("BackgroundWaitDialog.btnLabelCancel"));
        JPanel jPanel = new JPanel();
        jPanel.add(this.cancel);
        this.add((Component)jPanel, cellConstraints.xy(2, 6));
        this.msgLabel.setHorizontalAlignment(0);
        this.tskLabel.setHorizontalAlignment(0);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundWaitDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    protected void updateTaskCount(int n) {
        this.tskLabel.setText("" + n);
        if (n < 1) {
            this.setVisible(false);
            return;
        }
    }
}

