/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.ui;

import de.admadic.spiromat.ui.BackgroundManager;
import de.admadic.spiromat.ui.Messages;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class BackgroundStatus
extends JProgressBar {
    private static final long serialVersionUID = 1L;

    public BackgroundStatus() {
        super(0, 0, 100);
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setIndeterminate(false);
        this.setStringPainted(true);
        this.setString(Messages.getString("BackgroundStatus.idle"));
        this.setValue(0);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        BackgroundManager.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BackgroundStatus.this.updateStatus((Integer)propertyChangeEvent.getNewValue());
            }
        });
    }

    protected void updateStatus(Integer n) {
        int n2 = n;
        if (n2 == 0) {
            this.setValue(0);
            this.setString("-");
            this.setIndeterminate(false);
            this.setToolTipText(Messages.getString("BackgroundStatus.tooltipNoBackgroundTasks"));
        } else {
            this.setValue(n2 < 100 ? n2 : 99);
            this.setString("" + n2);
            this.setIndeterminate(true);
            String string = MessageFormat.format(Messages.getString("BackgroundStatus.tooltipBackgroundTasksRunning"), new Integer(n2));
            this.setToolTipText(string);
        }
        this.repaint();
    }
}

