/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.splash;

import de.admadic.spiromat.ui.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SplashWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static SplashWindow instance;
    ImageIcon splashImage = null;
    JLabel splashLabel = null;
    ImagePanel splashPanel = null;
    Timer timer;
    TimerTask timerTask;

    public static SplashWindow getInstance() {
        if (instance == null) {
            instance = new SplashWindow();
        }
        return instance;
    }

    private SplashWindow() {
        this.setIconImages(Util.loadLogoImages());
        this.splashImage = Util.loadImage("spiromat-splash3.png");
        this.splashPanel = new ImagePanel(this.splashImage);
        this.setContentPane(this.splashPanel);
        this.splashPanel.setLayout(null);
        this.splashLabel = new JLabel("");
        this.getContentPane().add(this.splashLabel);
        this.splashLabel.setBounds(5, 255, 250, 40);
        this.splashLabel.setFont(this.splashLabel.getFont().deriveFont(0).deriveFont(10.0f));
        this.splashLabel.setForeground(Color.decode("0x0066cc"));
        this.setUndecorated(true);
        this.setSize(400, 300);
        this.validate();
        this.setLocationRelativeTo(null);
        this.timer = new Timer("splash-timer", true);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                SplashWindow.this.timerRing();
            }
        };
    }

    protected void timerRing() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        });
    }

    public void showSplash() {
        this.timer.schedule(this.timerTask, 10000L);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.paintAll(this.getGraphics());
    }

    public void hideSplash() {
        if (!this.isVisible()) {
            return;
        }
        this.timerTask.cancel();
        this.setVisible(false);
        this.dispose();
    }

    public void setMessage(String string) {
        this.splashLabel.setText(string);
        this.splashLabel.paintAll(this.splashLabel.getGraphics());
    }

    static class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ImageIcon image;

        public ImagePanel(ImageIcon imageIcon) {
            this.setBackground(Color.WHITE);
            this.image = imageIcon;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.image != null) {
                graphics.drawImage(this.image.getImage(), 0, 0, this);
            }
        }
    }
}

