/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.shapes;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.FigureModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.shapes.Drawable;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class FigureView
implements Drawable,
PropertyChangeListener {
    static final Logger logger = Logger.getLogger(FigureView.class);
    FigureSpec figureSpec;
    FigureModel model;
    private int[] x = new int[0];
    private int[] y = new int[0];
    int count = 0;
    private boolean visible = true;
    private boolean ignoreActiveStatus = false;
    private final Stroke stroke = new BasicStroke(3.0f);
    private final Stroke strokeActive = new BasicStroke(5.0f);

    public FigureView(FigureSpec figureSpec) {
        this.figureSpec = figureSpec;
        this.model = this.figureSpec.getFigureModel();
        this.figureSpec.addPropertyChangeListener(this);
        this.ensureCapacity(11);
        this.updatePointsFromModel();
    }

    private void ensureCapacity(int n) {
        if (this.x.length < n) {
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.x, 0, nArray, 0, this.x.length);
            System.arraycopy(this.y, 0, nArray2, 0, this.y.length);
            this.x = nArray;
            this.y = nArray2;
        }
    }

    public void addPoint(Point point) {
        this.addPoint(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(int n, int n2) {
        if (this.count >= this.x.length) {
            this.ensureCapacity(2 * this.count + 1);
        }
        FigureView figureView = this;
        synchronized (figureView) {
            this.x[this.count] = n;
            this.y[this.count] = n2;
            ++this.count;
        }
    }

    public void setPoints(int[] nArray, int[] nArray2) {
        this.x = nArray;
        this.y = nArray2;
        this.count = this.x.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        FigureView figureView = this;
        synchronized (figureView) {
            logger.debug("clearing");
            this.count = 0;
        }
    }

    @Override
    public void drawReset() {
        logger.debug("resetting");
        this.model.clearDrawn();
    }

    @Override
    public void drawFull(Graphics2D graphics2D) {
        logger.debug("draw:  cur=" + this.count);
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(this.figureSpec.getColor());
        graphics2D.drawRect(-100, -100, 200, 200);
    }

    public void drawErase(Graphics2D graphics2D) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawStayingParts(Graphics2D graphics2D) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        logger.debug("drawStaying:  v=" + this.isVisible() + " Ro=" + this.figureSpec.getOuterRadius() + " Ri=" + this.figureSpec.getInnerRadius() + " L=" + this.figureSpec.getPenHolePos());
        if (!this.isVisible()) {
            return;
        }
        Object object = this.model;
        synchronized (object) {
            nArray4 = this.model.getDirtyAtStartPointsX();
            nArray3 = this.model.getDirtyAtStartPointsY();
            nArray2 = this.model.getDirtyAtEndPointsX();
            nArray = this.model.getDirtyAtEndPointsY();
            this.model.markDrawn();
        }
        object = graphics2D;
        ((Graphics)object).setPaintMode();
        Stroke stroke = null;
        stroke = this.isIgnoreActiveStatus() || AppModel.getInstance().getShowPicture() ? this.stroke : (this.figureSpec.isActive() ? this.strokeActive : this.stroke);
        ((Graphics2D)object).setStroke(stroke);
        ((Graphics)object).setColor(this.figureSpec.getColor());
        logger.debug("drawing: start=" + nArray4.length + " end=" + nArray2.length);
        ((Graphics)object).drawPolyline(nArray4, nArray3, nArray4.length);
        ((Graphics)object).drawPolyline(nArray2, nArray, nArray2.length);
    }

    @Override
    public void drawVolatileParts(Graphics2D graphics2D) {
        logger.debug("drawVolatile:  v=" + this.isVisible() + " Ro=" + this.figureSpec.getOuterRadius() + " Ri=" + this.figureSpec.getInnerRadius() + " L=" + this.figureSpec.getPenHolePos());
        if (!this.isVisible()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePointsFromModel() {
        FigureModel figureModel = this.model;
        synchronized (figureModel) {
            this.model.clearDrawn();
            this.setPoints(this.model.getPointsX(), this.model.getPointsY());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            logger.debug("propchange: " + string);
            if (string.equals("cleared")) {
                this.clear();
            } else if (string.equals("outerRadius") || string.equals("innerRadius") || string.equals("penHolePos")) {
                this.clear();
                this.updatePointsFromModel();
            } else if (string.equals("cursorAngle")) {
                // empty if block
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isIgnoreActiveStatus() {
        return this.ignoreActiveStatus;
    }

    public void setIgnoreActiveStatus(boolean bl) {
        this.ignoreActiveStatus = bl;
    }
}

