/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.shapes;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AbstractGearSpec;
import de.admadic.spiromat.shapes.Drawable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class AbstractGearView
implements Drawable,
PropertyChangeListener {
    static final Logger logger = Logger.getLogger(AbstractGearView.class);
    AbstractGearSpec gearSpec;
    protected int teeth;
    protected int teethHeight;
    int[] x;
    int[] y;
    double angle;
    double xc;
    double yc;
    boolean visible = true;
    static final float strokeWidth = 2.0f;

    public AbstractGearView(AbstractGearSpec abstractGearSpec) {
        this.gearSpec = abstractGearSpec;
        abstractGearSpec.addPropertyChangeListener(this);
        this.updateParameters();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("radius")) {
            this.updateParameters();
        }
    }

    void updateParameters() {
        double d = (double)(this.gearSpec.getRadius() * 500) / 100.0;
        this.teeth = this.gearSpec.getRadius();
        this.teethHeight = (int)(d * Math.PI * 2.0 / ((double)this.teeth * 1.5));
        this.initData();
    }

    protected abstract void initData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(double d, double d2, double d3) {
        logger.debug("setState:  angle=" + d);
        AbstractGearView abstractGearView = this;
        synchronized (abstractGearView) {
            this.angle = d;
            this.xc = d2;
            this.yc = d3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImpl(Graphics2D graphics2D) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        try {
            AffineTransform affineTransform = null;
            graphics2D2.setPaintMode();
            graphics2D2.setColor(this.gearSpec.getColor());
            graphics2D2.setPaint(this.gearSpec.getColor());
            graphics2D2.setStroke(new BasicStroke(2.0f));
            affineTransform = graphics2D2.getTransform();
            if (affineTransform == null) {
                affineTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
            }
            affineTransform.concatenate(AffineTransform.getTranslateInstance(this.xc, this.yc));
            affineTransform.concatenate(AffineTransform.getRotateInstance(this.angle));
            graphics2D2.setTransform(affineTransform);
            graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            this.drawShape(graphics2D2);
        }
        finally {
            graphics2D2.dispose();
        }
    }

    protected void drawShape(Graphics2D graphics2D) {
        if (this.isVisible()) {
            graphics2D.fillPolygon(this.x, this.y, this.x.length);
        }
    }

    int getTeeth() {
        return this.teeth;
    }

    int getTeethHeight() {
        return this.teethHeight;
    }

    @Override
    public void drawReset() {
        logger.debug("resetting: " + this);
    }

    @Override
    public void drawFull(Graphics2D graphics2D) {
        logger.debug("draw: " + this);
        this.drawImpl(graphics2D);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public void drawStayingParts(Graphics2D graphics2D) {
        logger.debug("drawStaying:  R=" + this.gearSpec.getRadius());
    }

    @Override
    public void drawVolatileParts(Graphics2D graphics2D) {
        logger.debug("drawVolatile:  R=" + this.gearSpec.getRadius());
        this.drawImpl(graphics2D);
    }
}

