/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model.types;

import de.admadic.spiromat.model.types.ComponentUpdater;
import de.admadic.spiromat.model.types.IProperty;
import de.admadic.spiromat.model.types.IPropertyChangeManager;
import java.awt.Component;

public abstract class AbstractProperty<T>
implements IProperty<T> {
    private final String name;
    private T value = null;
    private boolean enabled = true;
    private boolean visible = true;
    protected IPropertyChangeManager manager = null;
    private ComponentUpdater componentUpdater = new ComponentUpdater();

    public AbstractProperty(String string) {
        this.name = string;
    }

    public AbstractProperty(String string, T t) {
        this.name = string;
        this.setValue(t);
    }

    public AbstractProperty(String string, T t, IPropertyChangeManager iPropertyChangeManager) {
        this.name = string;
        this.manager = iPropertyChangeManager;
        this.setValue(t);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        if (bl2 != this.enabled) {
            this.componentUpdater.setEnabled(bl);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T t) {
        T t2 = this.value;
        this.value = t;
        if (this.manager != null) {
            this.manager.firePropertyChange(this.getName(), t2, this.value);
        }
    }

    public void addComponent(Component component) {
        this.componentUpdater.addComponent(component);
    }

    public void removeComponent(Component component) {
        this.componentUpdater.removeComponent(component);
    }
}

