/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model.io;

import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.io.SpiromatIOException;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class DocumentWriter
implements XMLReader {
    DocModel docModel;
    ContentHandler handler;
    String nsu = "";
    Attributes atts = new AttributesImpl();
    String rootElement = "spiromat";
    StringBuffer indentString = new StringBuffer("\n");

    public DocumentWriter(DocModel docModel) {
        this.docModel = docModel;
    }

    public void write() {
        try {
            File file = this.docModel.getFile();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            SAXSource sAXSource = new SAXSource(this, null);
            StreamResult streamResult = new StreamResult(file);
            transformer.transform(sAXSource, streamResult);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new SpiromatIOException("could not create output file", transformerException);
        }
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            if (this.handler == null) {
                throw new SAXException("No content handler");
            }
            this.handler.startDocument();
            this.indent(0);
            this.handler.startElement(this.nsu, this.rootElement, this.rootElement, this.atts);
            this.writeVersion();
            this.writeFigureSpecs();
            this.writeDocStatus();
            this.writeAppStatus();
            this.indent(0);
            this.handler.endElement(this.nsu, this.rootElement, this.rootElement);
            this.handler.endDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SpiromatIOException("could not generate file", exception);
        }
    }

    private String encodeColor(Color color) {
        int n = color.getRGB() & 0xFFFFFF;
        return "#" + Integer.toHexString(n);
    }

    private void indent(int n) throws SAXException {
        this.checkIndentString(n);
        this.handler.ignorableWhitespace(this.indentString.toString().toCharArray(), 0, n * 2 + 1);
    }

    private void checkIndentString(int n) {
        if (this.indentString.length() < n * 2 + 1) {
            int n2 = n * 2 - this.indentString.length() + 1;
            for (int i = 0; i < n2; ++i) {
                this.indentString.append(' ');
            }
        }
    }

    private void writeAppStatus() throws SAXException {
        this.indent(1);
        AttributesImpl attributesImpl = new AttributesImpl();
        this.handler.startElement(this.nsu, "", "appStatus", attributesImpl);
        this.indent(2);
        AttributesImpl attributesImpl2 = new AttributesImpl();
        attributesImpl2.addAttribute(this.nsu, "", "key", "", "");
        attributesImpl2.addAttribute(this.nsu, "", "value", "", "");
        this.handler.startElement(this.nsu, "", "param", attributesImpl2);
        this.indent(2);
        this.handler.endElement(this.nsu, "", "param");
        this.indent(1);
        this.handler.endElement(this.nsu, "", "appStatus");
    }

    private void writeDocStatus() throws SAXException {
        this.indent(1);
        AttributesImpl attributesImpl = new AttributesImpl();
        this.handler.startElement(this.nsu, "", "docStatus", attributesImpl);
        this.indent(2);
        AttributesImpl attributesImpl2 = null;
        attributesImpl2 = new AttributesImpl();
        attributesImpl2.addAttribute(this.nsu, "", "key", "type", "activeFigureIndex");
        attributesImpl2.addAttribute(this.nsu, "", "value", "type", "" + this.docModel.getActiveFigureIndex());
        this.handler.startElement(this.nsu, "", "param", attributesImpl2);
        this.indent(2);
        this.handler.endElement(this.nsu, "", "param");
        attributesImpl2 = new AttributesImpl();
        attributesImpl2.addAttribute(this.nsu, "", "key", "type", "defaultColorIndex");
        attributesImpl2.addAttribute(this.nsu, "", "value", "type", "" + this.docModel.getDefaultColorIndex());
        this.handler.startElement(this.nsu, "", "param", attributesImpl2);
        this.indent(2);
        this.handler.endElement(this.nsu, "", "param");
        this.indent(1);
        this.handler.endElement(this.nsu, "", "docStatus");
    }

    private void writeFigureSpecs() throws SAXException {
        this.indent(1);
        AttributesImpl attributesImpl = new AttributesImpl();
        AttributesImpl attributesImpl2 = new AttributesImpl();
        this.handler.startElement(this.nsu, "", "figureSpecs", attributesImpl);
        int n = this.docModel.getFigureSpecCount();
        for (int i = 0; i < n; ++i) {
            this.indent(2);
            FigureSpec figureSpec = this.docModel.getFigureSpec(i);
            AttributesImpl attributesImpl3 = new AttributesImpl();
            attributesImpl3.addAttribute(this.nsu, "", "outerRadius", "type", "" + figureSpec.getOuterRadius());
            attributesImpl3.addAttribute(this.nsu, "", "innerRadius", "type", "" + figureSpec.getInnerRadius());
            attributesImpl3.addAttribute(this.nsu, "", "penHolePos", "type", "" + figureSpec.getPenHolePos());
            attributesImpl3.addAttribute(this.nsu, "", "color", "type", this.encodeColor(figureSpec.getColor()));
            attributesImpl3.addAttribute(this.nsu, "", "startAngle", "type", "" + figureSpec.getStartAngle());
            attributesImpl3.addAttribute(this.nsu, "", "endAngle", "type", "" + figureSpec.getEndAngle());
            attributesImpl3.addAttribute(this.nsu, "", "cursorAngle", "type", "" + figureSpec.getCursorAngle());
            this.handler.startElement(this.nsu, "", "figureSpec", attributesImpl3);
            this.indent(3);
            this.handler.startElement(this.nsu, "", "status", attributesImpl2);
            this.indent(3);
            this.handler.endElement(this.nsu, "", "status");
            this.indent(2);
            this.handler.endElement(this.nsu, "", "figureSpec");
        }
        this.indent(1);
        this.handler.endElement(this.nsu, "", "figureSpecs");
    }

    private void writeVersion() throws SAXException {
        this.indent(1);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(this.nsu, "", "docVer", "type", "1.0");
        attributesImpl.addAttribute(this.nsu, "", "appMinVer", "type", "0.0");
        this.handler.startElement(this.nsu, "", "version", attributesImpl);
        this.indent(1);
        this.handler.endElement(this.nsu, "", "version");
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

