/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model.io;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.io.SpiromatIOException;
import de.admadic.spiromat.model.io.SpiromatVersionException;
import java.awt.Color;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentReader
extends DefaultHandler {
    static Logger logger = Logger.getLogger(DocumentReader.class);
    File file;
    DocModel docModel;
    private boolean inSpiromat = false;
    private boolean versionOk = false;
    private LinkedList<String> currentPath = new LinkedList();
    private StringBuffer currentPathString = new StringBuffer();
    private FigureSpec currentFigureSpec = null;
    private boolean hasActiveFigureIndex = false;

    public DocumentReader(File file) {
        this.file = file;
    }

    public void read() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.file, (DefaultHandler)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SpiromatIOException("error loading file", exception);
        }
        if (this.docModel == null || !this.versionOk) {
            throw new SpiromatIOException("could not load file");
        }
    }

    public DocModel getDocModel() {
        return this.docModel;
    }

    @Override
    public void startDocument() throws SAXException {
        logger.info("startDocument");
        this.docModel = new DocModel();
    }

    @Override
    public void endDocument() throws SAXException {
        logger.info("endDocument");
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.info("startElement: uri=" + string + " localName=" + string2 + " qName=" + string3);
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        this.appendToPath(string4);
        if (!this.inSpiromat) {
            if (string4.equals("spiromat")) {
                this.inSpiromat = true;
                logger.info("now inSpiromat=true");
                return;
            }
            logger.info("not in spiromat and also not root tag");
            return;
        }
        if (!this.versionOk) {
            logger.info("version not yet verified...");
            if (string4.equals("version")) {
                this.coreCheckVersion(attributes);
                logger.info("version verified!");
                return;
            }
            logger.info("ignoring as long as version is not yet found...");
            return;
        }
        logger.info("---> " + this.currentPathString);
        if (this.currentPathString.toString().equals("/spiromat/figureSpecs/figureSpec")) {
            this.coreCreateFigureSpec(attributes);
            return;
        }
        if (this.currentPathString.toString().equals("/spiromat/figureSpecs/figureSpec/status")) {
            this.coreSetFigureSpecStatus(attributes);
            return;
        }
        if (this.currentPathString.toString().equals("/spiromat/docStatus/param")) {
            this.coreSetDocStatus(attributes);
            if (!this.hasActiveFigureIndex) {
                throw new SpiromatIOException("the active figure was not specified");
            }
            return;
        }
        if (this.currentPathString.toString().equals("/spiromat/appStatus/param")) {
            this.coreSetAppStatus(attributes);
            return;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        logger.info("endElement: uri=" + string + " localName=" + string2 + " qName=" + string3);
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (this.currentPathString.toString().equals("/spiromat/figureSpecs/figureSpec")) {
            this.currentFigureSpec = null;
        } else if (this.currentPathString.toString().equals("/spiromat")) {
            this.inSpiromat = false;
        }
        this.removeFromPath(string4);
    }

    private void coreCreateFigureSpec(Attributes attributes) {
        int n = -1;
        int n2 = -1;
        double d = -1.0;
        Color color = null;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        String string = null;
        string = attributes.getValue("", "outerRadius");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SpiromatIOException("error parsing outer radius of FigureSpec");
        }
        string = attributes.getValue("", "innerRadius");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SpiromatIOException("error parsing inner radius of FigureSpec");
        }
        string = attributes.getValue("", "penHolePos");
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SpiromatIOException("error parsing pen hole position of FigureSpec");
        }
        string = attributes.getValue("", "color");
        try {
            color = Color.decode("0x" + string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SpiromatIOException("error parsing pen hole position of FigureSpec");
        }
        string = attributes.getValue("", "startAngle");
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SpiromatIOException("error parsing pen hole position of FigureSpec");
        }
        string = attributes.getValue("", "endAngle");
        try {
            d3 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SpiromatIOException("error parsing pen hole position of FigureSpec");
        }
        string = attributes.getValue("", "cursorAngle");
        try {
            d4 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SpiromatIOException("error parsing pen hole position of FigureSpec");
        }
        this.currentFigureSpec = new FigureSpec(n, n2, d, color);
        this.currentFigureSpec.setAngles(d2, d3, d4);
        this.docModel.addFigureSpec(this.currentFigureSpec);
    }

    private void coreSetFigureSpecStatus(Attributes attributes) {
        String string = attributes.getValue("", "visible");
        if (string != null) {
            boolean bl = Boolean.parseBoolean(string);
            logger.warn("attribute visible is not supported");
        }
    }

    private void coreSetDocStatus(Attributes attributes) {
        String string = attributes.getValue("", "key");
        String string2 = attributes.getValue("", "value");
        logger.info("docStatus handling: key=" + string + " value=" + string2);
        if (string.equals("activeFigureIndex")) {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SpiromatIOException("could not parse value for activeFigureIndex");
            }
            logger.info("found activeFigureIndex with value=" + n);
            this.docModel.setActiveFigureIndex(n);
            this.hasActiveFigureIndex = true;
        } else if (string.equals("defaultColorIndex")) {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SpiromatIOException("could not parse value for defaultColorIndex");
            }
            logger.info("found defaultColorIndex with value=" + n);
            this.docModel.setDefaultColorIndex(n);
        }
    }

    private void coreSetAppStatus(Attributes attributes) {
    }

    private void appendToPath(String string) {
        this.currentPath.push(string);
        this.currentPathString.append('/');
        this.currentPathString.append(string);
        logger.info("path is now: " + this.currentPathString);
    }

    private void removeFromPath(String string) {
        String string2 = this.currentPath.pop();
        if (!string2.equals(string)) {
            throw new SpiromatIOException("parser error");
        }
        this.currentPathString.delete(0, this.currentPathString.length());
        Iterator<String> iterator = this.currentPath.descendingIterator();
        while (iterator.hasNext()) {
            this.currentPathString.append('/');
            this.currentPathString.append(iterator.next());
        }
        logger.info("path is now: " + this.currentPathString);
    }

    private void coreCheckVersion(Attributes attributes) throws SpiromatIOException {
        String string = attributes.getValue("docVer");
        if (string == null) {
            throw new SpiromatVersionException("no document version found");
        }
        String string2 = attributes.getValue("appMinVer");
        if (string2 == null) {
            throw new SpiromatVersionException("no application version found");
        }
        if (!string.equals("1.0")) {
            throw new SpiromatVersionException("document version not supported");
        }
        this.versionOk = true;
    }
}

