/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model;

import de.admadic.spiromat.math.SpiroMath;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.InnerGearSpec;
import de.admadic.spiromat.model.OuterGearSpec;

public class ModelUtil {
    public static FigureSpec createStandardFigureSpec() {
        AppModel appModel = AppModel.getInstance();
        FigureSpec figureSpec = new FigureSpec(appModel.getOuterRadius(), appModel.getInnerRadius(), AppModel.getInstance().getLambda(), AppModel.getInstance().getColorFigure());
        if (AppModel.getInstance().getAutoFill()) {
            figureSpec.initFullInterval();
        }
        return figureSpec;
    }

    public static FigureSpec createStandardFigureSpec(DocModel docModel) {
        FigureSpec figureSpec = ModelUtil.createStandardFigureSpec();
        if (docModel != null) {
            figureSpec.setColor(docModel.getNextDefaultColor());
        }
        if (AppModel.getInstance().getAutoFill()) {
            figureSpec.initFullInterval();
        }
        return figureSpec;
    }

    public static InnerGearSpec createStandardInnerGearSpec() {
        AppModel appModel = AppModel.getInstance();
        InnerGearSpec innerGearSpec = new InnerGearSpec(appModel.getLambda(), appModel.getInnerRadius(), appModel.getColorInnerGear());
        return innerGearSpec;
    }

    public static OuterGearSpec createStandardOuterGearSpec() {
        AppModel appModel = AppModel.getInstance();
        OuterGearSpec outerGearSpec = new OuterGearSpec(appModel.getOuterRadius(), appModel.getColorOuterGear());
        return outerGearSpec;
    }

    public static SpiroMath createStandardSpiroMath() {
        return ModelUtil.createStandardSpiroMath(null);
    }

    public static SpiroMath createStandardSpiroMath(DocModel docModel) {
        SpiroMath spiroMath;
        if (docModel == null) {
            AppModel appModel = AppModel.getInstance();
            spiroMath = new SpiroMath(appModel.getOuterRadius() * 500 / 100, appModel.getInnerRadius() * 500 / 100, appModel.getLambda());
        } else {
            FigureSpec figureSpec = docModel.getActiveFigureSpec();
            spiroMath = new SpiroMath(figureSpec.getOuterRadius() * 500 / 100, figureSpec.getInnerRadius() * 500 / 100, figureSpec.getPenHolePos());
        }
        return spiroMath;
    }
}

