/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.ModelPropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ModelPropertyChangeSupport
implements ModelPropertyChangeListener {
    static Logger logger = Logger.getLogger(ModelPropertyChangeSupport.class);
    private final int mask;
    public static final int MASK_APP = 1;
    public static final int MASK_DOC = 2;
    public static final int MASK_FIG = 4;
    public static final int MASK_ALL = -1;
    private AppModel appModel;
    private DocModel docModel;
    private FigureSpec activeFigureSpec;
    private PropertyChangeListener appListener;
    private PropertyChangeListener docListener;
    private PropertyChangeListener figListener;
    private ModelPropertyChangeListener externalListener;

    public ModelPropertyChangeSupport() {
        this(-1, null, true);
    }

    public ModelPropertyChangeSupport(ModelPropertyChangeListener modelPropertyChangeListener) {
        this(-1, modelPropertyChangeListener, true);
    }

    public ModelPropertyChangeSupport(int n, ModelPropertyChangeListener modelPropertyChangeListener, boolean bl) {
        this.mask = n;
        ModelPropertyChangeListener modelPropertyChangeListener2 = this.externalListener = modelPropertyChangeListener == null ? this : modelPropertyChangeListener;
        if (this.isEnabled(1)) {
            this.appListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ModelPropertyChangeSupport.this.coreAppPropertyChange(propertyChangeEvent);
                }
            };
        }
        if (this.isEnabled(2)) {
            this.docListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ModelPropertyChangeSupport.this.coreDocPropertyChange(propertyChangeEvent);
                }
            };
        }
        if (this.isEnabled(4)) {
            this.figListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ModelPropertyChangeSupport.this.coreFigPropertyChange(propertyChangeEvent);
                }
            };
        }
        if (bl) {
            this.attachToAppModel();
        }
    }

    public void detachFromAppModel() {
        logger.debug("detaching from AppModel");
        this.setAppModel(null);
    }

    public void attachToAppModel() {
        logger.debug("attaching to AppModel");
        if (this.isEnabled(1)) {
            this.setAppModel(AppModel.getInstance());
        }
    }

    protected boolean isEnabled(int n) {
        return (this.mask & n) != 0;
    }

    protected void setAppModel(AppModel appModel) {
        logger.debug("setting AppModel = " + appModel);
        if (this.appModel != null) {
            this.appModel.removePropertyChangeListener(this.appListener);
            this.appModel = null;
        }
        this.appModel = appModel;
        DocModel docModel = null;
        if (this.appModel != null) {
            this.appModel.addPropertyChangeListener(this.appListener);
            docModel = this.appModel.getDocModel();
        }
        if (this.isEnabled(2)) {
            this.setDocModel(docModel);
        }
    }

    protected void setDocModel(DocModel docModel) {
        logger.debug("setting DocModel = " + docModel);
        if (this.docModel != null) {
            this.docModel.removePropertyChangeListener(this.docListener);
            this.docModel = null;
        }
        this.docModel = docModel;
        FigureSpec figureSpec = null;
        if (this.docModel != null) {
            this.docModel.addPropertyChangeListener(this.docListener);
            figureSpec = this.docModel.getActiveFigureSpec();
        }
        if (this.isEnabled(4)) {
            this.setFigureSpec(figureSpec);
        }
    }

    protected void setFigureSpec(FigureSpec figureSpec) {
        logger.debug("setting FigureSpec = " + figureSpec);
        if (this.activeFigureSpec != null) {
            this.activeFigureSpec.removePropertyChangeListener(this.figListener);
            this.activeFigureSpec = null;
        }
        this.activeFigureSpec = figureSpec;
        if (this.activeFigureSpec != null) {
            this.activeFigureSpec.addPropertyChangeListener(this.figListener);
        }
    }

    protected void coreAppPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        logger.debug("coreAppPropertyChange: " + propertyChangeEvent.getPropertyName());
        this.externalListener.appPropertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("docModel")) {
            this.setDocModel(AppModel.getInstance().getDocModel());
        }
    }

    protected void coreDocPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        logger.debug("coreDocPropertyChange: " + propertyChangeEvent.getPropertyName());
        this.externalListener.docPropertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("activeFigure")) {
            this.setFigureSpec(AppModel.getInstance().getDocModel().getActiveFigureSpec());
        }
    }

    protected void coreFigPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        logger.debug("coreFigPropertyChange: " + propertyChangeEvent.getPropertyName());
        this.externalListener.figPropertyChange(propertyChangeEvent);
    }

    @Override
    public void appPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void docPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void figPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

