/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model;

import de.admadic.spiromat.DontObfuscate;
import de.admadic.spiromat.math.Util;
import de.admadic.spiromat.model.FigureModel;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FigureSpec
implements Serializable,
DontObfuscate {
    private static final long serialVersionUID = 1L;
    private int outerRadius;
    private int innerRadius;
    private double penHolePos;
    private double maxAngleInterval;
    private double offsetAngle;
    private double startAngle;
    private double endAngle;
    private double cursorAngle;
    private Color color;
    private boolean active;
    private transient FigureModel cachedFigureModel;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_OUTER_RADIUS = "outerRadius";
    public static final String PROP_INNER_RADIUS = "innerRadius";
    public static final String PROP_PEN_HOLE_POS = "penHolePos";
    public static final String PROP_OFFSET_ANGLE = "offsetAngle";
    public static final String PROP_START_ANGLE = "startAngle";
    public static final String PROP_END_ANGLE = "endAngle";
    public static final String PROP_CURSOR_ANGLE = "cursorAngle";
    public static final String PROP_COLOR = "color";
    public static final String PROP_CLEARED = "cleared";

    public FigureSpec(int n, int n2, double d, Color color) {
        this.outerRadius = n;
        this.innerRadius = n2;
        this.penHolePos = d;
        this.updateMaxAngleInterval();
        this.offsetAngle = 0.0;
        this.startAngle = 0.0;
        this.endAngle = 0.0;
        this.cursorAngle = 0.0;
        this.color = color;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pcs = new PropertyChangeSupport(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public void setAngles(double d, double d2, double d3) {
        this.startAngle = d;
        this.endAngle = d2;
        this.updateCachedFigureModel(this.startAngle);
        this.updateCachedFigureModel(this.endAngle);
        this.setCursorAngle(d3);
    }

    public void initFullInterval() {
        this.startAngle = 0.0;
        this.cursorAngle = this.endAngle = this.maxAngleInterval;
        this.updateCachedFigureModel(this.cursorAngle);
        this.pcs.firePropertyChange(PROP_CURSOR_ANGLE, -1.0 - this.cursorAngle, this.cursorAngle);
    }

    public void clear() {
        this.offsetAngle = 0.0;
        this.startAngle = 0.0;
        this.endAngle = 0.0;
        this.cursorAngle = 0.0;
        this.clearCachedFigureModel();
        this.pcs.firePropertyChange(PROP_CLEARED, false, true);
    }

    private void updateMaxAngleInterval() {
        int n = Util.calculateRounds(this.outerRadius, this.innerRadius);
        this.maxAngleInterval = (double)(n * 2) * Math.PI;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color color2 = this.color;
        this.color = color;
        this.pcs.firePropertyChange(PROP_COLOR, color2, this.color);
    }

    public int getInnerRadius() {
        return this.innerRadius;
    }

    public int getOuterRadius() {
        return this.outerRadius;
    }

    public double getPenHolePos() {
        return this.penHolePos;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public double getOffsetAngle() {
        return this.offsetAngle;
    }

    public double getCursorAngle() {
        return this.cursorAngle;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setInnerRadius(int n) {
        int n2 = this.innerRadius;
        this.innerRadius = n;
        this.updateMaxAngleInterval();
        this.updateCachedFigureModel(this.outerRadius, this.innerRadius, this.penHolePos);
        this.pcs.firePropertyChange(PROP_INNER_RADIUS, n2, this.innerRadius);
    }

    public void setOffsetAngle(double d) {
        double d2 = this.offsetAngle;
        this.offsetAngle = d;
        this.pcs.firePropertyChange(PROP_OFFSET_ANGLE, d2, this.offsetAngle);
    }

    public void setCursorAngle(double d) {
        double d2 = this.cursorAngle;
        this.cursorAngle = d;
        if (this.cursorAngle < this.startAngle) {
            this.setStartAngle(this.cursorAngle);
        } else if (this.cursorAngle > this.endAngle) {
            this.setEndAngle(this.cursorAngle);
        }
        this.updateCachedFigureModel(this.cursorAngle);
        this.pcs.firePropertyChange(PROP_CURSOR_ANGLE, d2, this.cursorAngle);
    }

    public void setOuterRadius(int n) {
        int n2 = this.outerRadius;
        this.outerRadius = n;
        this.updateMaxAngleInterval();
        this.updateCachedFigureModel(this.outerRadius, this.innerRadius, this.penHolePos);
        this.pcs.firePropertyChange(PROP_OUTER_RADIUS, n2, this.outerRadius);
    }

    public void setPenHolePos(double d) {
        double d2 = this.penHolePos;
        this.penHolePos = d;
        this.updateCachedFigureModel(this.outerRadius, this.innerRadius, this.penHolePos);
        this.pcs.firePropertyChange(PROP_PEN_HOLE_POS, d2, this.penHolePos);
    }

    private void setStartAngle(double d) {
        double d2 = this.startAngle;
        this.startAngle = d;
        this.pcs.firePropertyChange(PROP_START_ANGLE, d2, this.startAngle);
    }

    private void setEndAngle(double d) {
        double d2 = this.endAngle;
        this.endAngle = d;
        this.pcs.firePropertyChange(PROP_END_ANGLE, d2, this.endAngle);
    }

    public FigureModel getFigureModel() {
        if (this.cachedFigureModel == null) {
            this.cachedFigureModel = FigureSpec.createFigureModel(this);
        }
        return this.cachedFigureModel;
    }

    private void updateCachedFigureModel(int n, int n2, double d) {
        if (this.cachedFigureModel == null) {
            return;
        }
        this.cachedFigureModel.setParameters(n * 500 / 100, n2 * 500 / 100, d, 0.0);
    }

    private void updateCachedFigureModel(double d) {
        if (this.cachedFigureModel == null) {
            return;
        }
        this.cachedFigureModel.addPoints(d);
    }

    private void clearCachedFigureModel() {
        if (this.cachedFigureModel == null) {
            return;
        }
        this.cachedFigureModel.clear();
    }

    private static FigureModel createFigureModel(FigureSpec figureSpec) {
        FigureModel figureModel = new FigureModel(figureSpec.getOuterRadius() * 500 / 100, figureSpec.getInnerRadius() * 500 / 100, figureSpec.getPenHolePos());
        figureModel.addPoints(figureSpec.getStartAngle());
        figureModel.addPoints(figureSpec.getEndAngle());
        return figureModel;
    }
}

