/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.math.SpiroMath;
import de.admadic.spiromat.math.Util;

public class FigureModel {
    static final Logger logger = Logger.getLogger(FigureModel.class);
    SpiroMath spiroMath;
    double phiMin;
    double phiMax;
    double phiSpan;
    float[] xAry;
    float[] yAry;
    int[] xAryInt;
    int[] yAryInt;
    int startIndex;
    int endIndex;
    int drawnStartIndex = -1;
    int drawnEndIndex = -1;
    double deltaPhi = 0.12566370614359174;

    public FigureModel(double d, double d2, double d3) {
        this(d, d2, d3, 0.0);
    }

    public FigureModel(double d, double d2, double d3, double d4) {
        this.setParameters(d, d2, d3, d4);
    }

    public void setParameters(double d, double d2, double d3, double d4) {
        logger.debug("setting new parameters... (clearing data!)");
        this.spiroMath = new SpiroMath(d, d2, d3);
        this.phiMin = d4;
        this.phiMax = d4;
        this.phiSpan = (double)Util.calculateRounds((int)d, (int)d2) * Math.PI * 2.0;
        this.xAry = new float[17];
        this.yAry = new float[17];
        this.xAryInt = new int[17];
        this.yAryInt = new int[17];
        this.startIndex = 5;
        this.endIndex = 5;
        this.drawnStartIndex = -1;
        this.drawnEndIndex = -1;
    }

    public synchronized boolean addPoints(double d) {
        logger.debug("addPoints: phi=" + d);
        if (d >= this.phiMin && d <= this.phiMax) {
            return false;
        }
        if (this.phiMax - this.phiMin >= this.phiSpan) {
            return false;
        }
        if (d < this.phiMin) {
            for (double d2 = this.phiMin; d2 > d; d2 -= this.deltaPhi) {
                this.addPoint(d2, false);
            }
            this.addPoint(d, false);
        } else {
            for (double d3 = this.phiMax; d3 < d; d3 += this.deltaPhi) {
                this.addPoint(d3, true);
            }
            this.addPoint(d, true);
        }
        if (d < this.phiMin) {
            this.phiMin = d;
        }
        if (d > this.phiMax) {
            this.phiMax = d;
        }
        return true;
    }

    private void addPoint(double d, boolean bl) {
        this.spiroMath.calculate(d);
        double d2 = this.spiroMath.getFigureX();
        double d3 = this.spiroMath.getFigureY();
        if (bl) {
            if (this.endIndex >= this.xAryInt.length) {
                this.growEnd();
            }
            this.xAry[this.endIndex] = (float)d2;
            this.yAry[this.endIndex] = (float)d3;
            this.xAryInt[this.endIndex] = (int)d2;
            this.yAryInt[this.endIndex] = (int)d3;
            ++this.endIndex;
        } else {
            if (this.startIndex == 0) {
                this.growStart();
            }
            --this.startIndex;
            this.xAry[this.startIndex] = (float)d2;
            this.yAry[this.startIndex] = (float)d3;
            this.xAryInt[this.startIndex] = (int)d2;
            this.yAryInt[this.startIndex] = (int)d3;
        }
    }

    private void growStart() {
        int n = this.xAryInt.length / 4;
        int n2 = this.xAryInt.length + n;
        if (logger.isDebugEnabled()) {
            logger.debug("growing start by " + n + " elements");
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        System.arraycopy(this.xAryInt, this.startIndex, nArray, n + this.startIndex, this.endIndex - this.startIndex);
        System.arraycopy(this.yAryInt, this.startIndex, nArray2, n + this.startIndex, this.endIndex - this.startIndex);
        System.arraycopy(this.xAry, this.startIndex, fArray, n + this.startIndex, this.endIndex - this.startIndex);
        System.arraycopy(this.yAry, this.startIndex, fArray2, n + this.startIndex, this.endIndex - this.startIndex);
        this.startIndex += n;
        this.endIndex += n;
        this.xAryInt = nArray;
        this.yAryInt = nArray2;
        this.xAry = fArray;
        this.yAry = fArray2;
        if (this.drawnStartIndex >= 0) {
            this.drawnStartIndex += n;
            this.drawnEndIndex += n;
        }
    }

    private void growEnd() {
        int n = this.xAryInt.length / 4;
        int n2 = this.xAryInt.length + n;
        if (logger.isDebugEnabled()) {
            logger.debug("growing end by " + n + " elements");
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        System.arraycopy(this.xAryInt, this.startIndex, nArray, this.startIndex, this.endIndex - this.startIndex);
        System.arraycopy(this.yAryInt, this.startIndex, nArray2, this.startIndex, this.endIndex - this.startIndex);
        System.arraycopy(this.xAry, this.startIndex, fArray, this.startIndex, this.endIndex - this.startIndex);
        System.arraycopy(this.yAry, this.startIndex, fArray2, this.startIndex, this.endIndex - this.startIndex);
        this.xAryInt = nArray;
        this.yAryInt = nArray2;
        this.xAry = fArray;
        this.yAry = fArray2;
    }

    public int[] getPointsX() {
        int[] nArray = new int[this.endIndex - this.startIndex];
        System.arraycopy(this.xAryInt, this.startIndex, nArray, 0, this.endIndex - this.startIndex);
        return nArray;
    }

    public int[] getPointsY() {
        int[] nArray = new int[this.endIndex - this.startIndex];
        System.arraycopy(this.yAryInt, this.startIndex, nArray, 0, this.endIndex - this.startIndex);
        return nArray;
    }

    public boolean isDirtyAtStart() {
        return this.drawnStartIndex != this.startIndex;
    }

    public boolean isDirtyAtEnd() {
        return this.drawnEndIndex != this.endIndex;
    }

    public int[] getDirtyAtStartPointsX() {
        if (this.drawnStartIndex < 0) {
            logger.debug("not drawn yet, returning nothing");
            return new int[0];
        }
        if (this.drawnStartIndex == this.startIndex) {
            logger.debug("no new data, returning nothing");
            return new int[0];
        }
        int n = this.drawnStartIndex - this.startIndex + 1;
        if (this.endIndex == this.drawnStartIndex) {
            --n;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("returning " + n + " elements, si,ei,dsi,dei=" + this.startIndex + "," + this.endIndex + "," + this.drawnStartIndex + "," + this.drawnEndIndex);
        }
        int[] nArray = new int[n];
        System.arraycopy(this.xAryInt, this.startIndex, nArray, 0, n);
        return nArray;
    }

    public int[] getDirtyAtStartPointsY() {
        if (this.drawnStartIndex < 0) {
            logger.debug("not drawn yet, returning nothing");
            return new int[0];
        }
        if (this.drawnStartIndex == this.startIndex) {
            logger.debug("no new data, returning nothing");
            return new int[0];
        }
        int n = this.drawnStartIndex - this.startIndex + 1;
        if (this.endIndex == this.drawnStartIndex) {
            --n;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("returning " + n + " elements, si,ei,dsi,dei=" + this.startIndex + "," + this.endIndex + "," + this.drawnStartIndex + "," + this.drawnEndIndex);
        }
        int[] nArray = new int[n];
        System.arraycopy(this.yAryInt, this.startIndex, nArray, 0, n);
        return nArray;
    }

    public int[] getDirtyAtEndPointsX() {
        if (this.drawnEndIndex < 0) {
            logger.debug("not drawn yet, returning full");
            return this.getPointsX();
        }
        if (this.drawnEndIndex == this.endIndex) {
            logger.debug("no new data, returning nothing");
            return new int[0];
        }
        int n = this.endIndex - this.drawnEndIndex;
        if (logger.isDebugEnabled()) {
            logger.debug("returning " + n + " elements, si,ei,dsi,dei=" + this.startIndex + "," + this.endIndex + "," + this.drawnStartIndex + "," + this.drawnEndIndex);
        }
        int[] nArray = new int[n];
        System.arraycopy(this.xAryInt, this.endIndex - n, nArray, 0, n);
        return nArray;
    }

    public int[] getDirtyAtEndPointsY() {
        if (this.drawnEndIndex < 0) {
            logger.debug("not drawn yet, returning full");
            return this.getPointsY();
        }
        if (this.drawnEndIndex == this.endIndex) {
            logger.debug("no new data, returning nothing");
            return new int[0];
        }
        int n = this.endIndex - this.drawnEndIndex;
        if (logger.isDebugEnabled()) {
            logger.debug("returning " + n + " elements, si,ei,dsi,dei=" + this.startIndex + "," + this.endIndex + "," + this.drawnStartIndex + "," + this.drawnEndIndex);
        }
        int[] nArray = new int[n];
        System.arraycopy(this.yAryInt, this.endIndex - n, nArray, 0, n);
        return nArray;
    }

    public void markDrawn() {
        this.drawnStartIndex = this.startIndex;
        this.drawnEndIndex = this.endIndex;
    }

    public synchronized void clear() {
        logger.debug("clear called (clearing data!)");
        this.endIndex = this.startIndex = this.xAryInt.length / 2;
        this.drawnStartIndex = -1;
        this.drawnEndIndex = -1;
        this.phiMin = 0.0;
        this.phiMax = 0.0;
    }

    public void clearDrawn() {
        logger.debug("clearDrawn called");
        this.drawnStartIndex = -1;
        this.drawnEndIndex = -1;
    }
}

