/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model;

import de.admadic.spiromat.DontObfuscate;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.ModelUtil;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DocModel
implements Serializable,
DontObfuscate {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(DocModel.class);
    private ArrayList<FigureSpec> figureSpecs = new ArrayList();
    private int activeFigureIndex = -1;
    private File file;
    private boolean dirty;
    private transient ArrayList<ListDataListener> listDataListeners = new ArrayList();
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROPERTY_FIGURE_LIST = "figureList";
    public static final String PROPERTY_FIGURE_LIST_CONTENT_CHANGED = "figureListContent";
    public static final String PROPERTY_DOC_MODEL_DIRTY = "docModelDirty";
    public static final String PROPERTY_ACTIVE_FIGURE = "activeFigure";
    private transient PropertyChangeListener figureChangeListener;
    private int defaultColorIndex = 0;
    private Color[] defaultColors = new Color[]{Color.decode("0x339933"), Color.ORANGE, Color.decode("0x0066cc"), Color.RED};
    private transient boolean activeFigureSpecLocked = false;

    public DocModel() {
        this.initFigureChangeListener();
    }

    private void initFigureChangeListener() {
        this.figureChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                logger.debug("figure changed: setting dirty flag");
                DocModel.this.setDirty(true);
            }
        };
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listDataListeners = new ArrayList();
        this.pcs = new PropertyChangeSupport(this);
        this.initFigureChangeListener();
        for (FigureSpec figureSpec : this.figureSpecs) {
            figureSpec.addPropertyChangeListener(this.figureChangeListener);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public void setDefaults() {
        this.figureSpecs.clear();
        this.addFigureSpec(ModelUtil.createStandardFigureSpec(this));
    }

    public void addFigureSpec(FigureSpec figureSpec) {
        int n = this.figureSpecs.size();
        this.figureSpecs.add(figureSpec);
        this.setDirty(true);
        this.fireIntervalAdded(n, n);
        this.firePropertyChange(n, this.figureSpecs.size());
        if (n == 0) {
            this.setActiveFigureIndex(0);
        }
        figureSpec.addPropertyChangeListener(this.figureChangeListener);
    }

    public int getFigureSpecCount() {
        return this.figureSpecs.size();
    }

    public FigureSpec getActiveFigureSpec() {
        return this.activeFigureIndex >= 0 ? this.figureSpecs.get(this.activeFigureIndex) : null;
    }

    public FigureSpec getFigureSpec(int n) {
        return this.figureSpecs.get(n);
    }

    public void removeFigureSpec(FigureSpec figureSpec) {
        int n = this.figureSpecs.size();
        if (n <= 1) {
            logger.warn("cannot remove last FigureSpec");
            return;
        }
        int n2 = this.figureSpecs.indexOf(figureSpec);
        if (n2 < 0) {
            return;
        }
        this.removeFigureSpec(n2);
    }

    public void removeFigureSpec(int n) {
        int n2 = this.figureSpecs.size();
        if (n2 <= 1) {
            logger.warn("cannot remove last FigureSpec");
            return;
        }
        FigureSpec figureSpec = this.figureSpecs.get(n);
        figureSpec.removePropertyChangeListener(this.figureChangeListener);
        int n3 = this.getActiveFigureIndex();
        if (n3 == n) {
            this.setActiveFigureIndex(-1);
        }
        this.figureSpecs.remove(n);
        if (n3 != -1 && n3 >= this.figureSpecs.size()) {
            n3 = this.figureSpecs.size() - 1;
        }
        this.setDirty(true);
        this.fireIntervalRemoved(n, n + 1);
        this.firePropertyChange(n2, this.figureSpecs.size());
        if (n3 != -1) {
            this.setActiveFigureIndex(n3);
        }
    }

    public void exchangeFigureSpecsAt(int n, int n2) {
        logger.debug("exchanging " + n + " with " + n2);
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("indexes must be non-negative integers");
        }
        int n3 = this.figureSpecs.size();
        if (n >= n3 || n2 >= n3) {
            throw new IllegalArgumentException("indexes must be less than the number of FigureSpecs");
        }
        if (n == n2) {
            return;
        }
        FigureSpec figureSpec = this.figureSpecs.get(n);
        FigureSpec figureSpec2 = this.figureSpecs.get(n2);
        this.figureSpecs.set(n, figureSpec2);
        this.figureSpecs.set(n2, figureSpec);
        this.setDirty(true);
        this.fireContentsChanged(n, n2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(int n, int n2) {
        this.pcs.firePropertyChange(PROPERTY_FIGURE_LIST, n, n2);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public WeakReference<ArrayList<FigureSpec>> getFigureListReference() {
        return new WeakReference<ArrayList<FigureSpec>>(this.figureSpecs);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        if (this.dirty == bl) {
            return;
        }
        boolean bl2 = this.dirty;
        this.dirty = bl;
        this.pcs.firePropertyChange(PROPERTY_DOC_MODEL_DIRTY, bl2, this.dirty);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.setDirty(true);
    }

    public Color getNextDefaultColor() {
        Color color = this.defaultColors[this.defaultColorIndex++];
        if (this.defaultColorIndex >= this.defaultColors.length) {
            this.defaultColorIndex = 0;
        }
        return color;
    }

    public int getDefaultColorIndex() {
        return this.defaultColorIndex;
    }

    public void setDefaultColorIndex(int n) {
        this.defaultColorIndex = n;
    }

    public int getActiveFigureIndex() {
        return this.activeFigureIndex;
    }

    public void setActiveFigureIndex(int n) {
        if (n >= this.figureSpecs.size()) {
            logger.warn("tried to set active figure index out of range");
            return;
        }
        FigureSpec figureSpec = null;
        if (this.activeFigureIndex >= 0) {
            figureSpec = this.figureSpecs.get(this.activeFigureIndex);
            figureSpec.setActive(false);
        }
        this.setDirty(true);
        this.pcs.firePropertyChange(PROPERTY_ACTIVE_FIGURE, figureSpec, (Object)-1);
        this.activeFigureIndex = n;
        FigureSpec figureSpec2 = null;
        if (this.activeFigureIndex >= 0) {
            figureSpec2 = this.figureSpecs.get(this.activeFigureIndex);
            figureSpec2.setActive(true);
        }
        this.pcs.firePropertyChange(PROPERTY_ACTIVE_FIGURE, (Object)-1, figureSpec2);
    }

    protected void fireIntervalAdded(int n, int n2) {
        Iterator<ListDataListener> iterator = this.listDataListeners.iterator();
        ListDataEvent listDataEvent = null;
        while (iterator.hasNext()) {
            ListDataListener listDataListener = iterator.next();
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 1, n, n2);
            }
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    protected void fireIntervalRemoved(int n, int n2) {
        Iterator<ListDataListener> iterator = this.listDataListeners.iterator();
        ListDataEvent listDataEvent = null;
        while (iterator.hasNext()) {
            ListDataListener listDataListener = iterator.next();
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 2, n, n2);
            }
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    protected void fireContentsChanged(int n, int n2) {
        this.pcs.firePropertyChange(PROPERTY_FIGURE_LIST_CONTENT_CHANGED, false, true);
        Iterator<ListDataListener> iterator = this.listDataListeners.iterator();
        ListDataEvent listDataEvent = null;
        while (iterator.hasNext()) {
            ListDataListener listDataListener = iterator.next();
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, n, n2);
            }
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.add(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.remove(listDataListener);
    }

    public boolean isActiveFigureSpecLocked() {
        return this.activeFigureSpecLocked;
    }

    public void setActiveFigureSpecLocked(boolean bl) {
        this.activeFigureSpecLocked = bl;
    }
}

