/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.model;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.types.AbstractProperty;
import de.admadic.spiromat.model.types.BooleanActionProperty;
import de.admadic.spiromat.model.types.BooleanProperty;
import de.admadic.spiromat.model.types.ColorProperty;
import de.admadic.spiromat.model.types.DoubleProperty;
import de.admadic.spiromat.model.types.GenericProperty;
import de.admadic.spiromat.model.types.IProperty;
import de.admadic.spiromat.model.types.IPropertyChangeManager;
import de.admadic.spiromat.model.types.IntegerProperty;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;

public final class AppModel
implements IPropertyChangeManager {
    private static final Logger logger = Logger.getLogger(AppModel.class);
    private static AppModel singletonInstance = null;
    private BooleanProperty _animated;
    private BooleanProperty _mouseControlled;
    private BooleanProperty _instantUpdate;
    private BooleanProperty _showGears;
    private BooleanProperty _showFigure;
    private BooleanProperty _autoFill;
    private BooleanProperty _showPicture;
    private transient BooleanProperty _showFigureTemporarily;
    private transient BooleanProperty _holdFigure;
    private transient BooleanActionProperty _fillFigure;
    private transient BooleanActionProperty _clearFigure;
    private transient GenericProperty<DocModel> _docModel;
    private BooleanProperty _antialiasing;
    private IntegerProperty _timeRound;
    private DoubleProperty _figureAlpha;
    private ColorProperty _colorFigure;
    private ColorProperty _colorOuterGear;
    private ColorProperty _colorInnerGear;
    private ColorProperty _colorMouseGuide;
    private ColorProperty _colorCanvas;
    private IntegerProperty _outerRadius;
    private IntegerProperty _innerRadius;
    private DoubleProperty _lambda;
    private BooleanProperty _started;
    private BooleanProperty _pause;
    public static final String SHOW_GEARS = "showGears";
    public static final String SHOW_FIGURE = "showFigure";
    public static final String SHOW_FIGURE_TEMPORARILY = "showFigureTemporarily";
    public static final String SHOW_PICTURE = "showPicture";
    public static final String AUTO_FILL = "autoFill";
    public static final String HOLD_FIGURE = "holdFigure";
    public static final String CLEAR_FIGURE = "clearFigure";
    public static final String FILL_FIGURE = "fillFigure";
    public static final String ANIMATED = "animated";
    public static final String MOUSE_CONTROLLED = "mouseControlled";
    public static final String INSTANT_UPDATE = "instantUpdate";
    public static final String ANTIALIASING = "antialiasing";
    public static final String TIME_ROUND = "timeRound";
    public static final String FIGURE_ALPHA = "figureAlpha";
    public static final String COLOR_FIGURE = "colorFigure";
    public static final String COLOR_INNER_GEAR = "colorInnerGear";
    public static final String COLOR_OUTER_GEAR = "colorOuterGear";
    public static final String COLOR_MOUSE_GUIDE = "colorMouseGuide";
    public static final String COLOR_CANVAS = "colorCanvas";
    public static final String OUTER_RADIUS = "outerRadius";
    public static final String INNER_RADIUS = "innerRadius";
    public static final String LAMBDA = "lambda";
    public static final String STARTED = "started";
    public static final String PAUSE = "pause";
    public static final String DOC_MODEL = "docModel";
    private HashMap<String, IProperty> propertyHash;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static AppModel getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new AppModel();
        }
        return singletonInstance;
    }

    private AppModel() {
        this.setDefaults();
        this.initPropertySpecs();
    }

    public synchronized void addComponent(String string, Component component) {
        AbstractProperty abstractProperty = (AbstractProperty)this.propertyHash.get(string);
        abstractProperty.addComponent(component);
    }

    public synchronized void removeComponent(String string, Component component) {
        AbstractProperty abstractProperty = (AbstractProperty)this.propertyHash.get(string);
        abstractProperty.removeComponent(component);
    }

    public synchronized void setEnabled(String string, boolean bl) {
        AbstractProperty abstractProperty = (AbstractProperty)this.propertyHash.get(string);
        abstractProperty.setEnabled(bl);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    public synchronized void firePropertyChange(String string, int n, int n2) {
        this.propertyChangeSupport.firePropertyChange(string, n, n2);
    }

    @Override
    public synchronized void firePropertyChange(String string, Object object, Object object2) {
        logger.debug("propchange: " + string + ": " + object + " -> " + object2);
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized boolean getAnimated() {
        return this._animated.booleanValue();
    }

    public synchronized void setAnimated(boolean bl) {
        if (bl) {
            this.setMouseControlled(false);
            this.setInstantUpdate(false);
        }
        this._animated.setBooleanValue(bl);
    }

    public synchronized boolean getAntialiasing() {
        return this._antialiasing.booleanValue();
    }

    public synchronized void setAntialiasing(boolean bl) {
        this._antialiasing.setBooleanValue(bl);
    }

    public synchronized Color getColorFigure() {
        return (Color)this._colorFigure.getValue();
    }

    public synchronized void setColorFigure(Color color) {
        this._colorFigure.setValue(color);
    }

    public synchronized Color getColorInnerGear() {
        return (Color)this._colorInnerGear.getValue();
    }

    public synchronized void setColorInnerGear(Color color) {
        this._colorInnerGear.setValue(color);
    }

    public synchronized Color getColorMouseGuide() {
        return (Color)this._colorMouseGuide.getValue();
    }

    public synchronized void setColorMouseGuide(Color color) {
        this._colorMouseGuide.setValue(color);
    }

    public synchronized Color getColorCanvas() {
        return (Color)this._colorCanvas.getValue();
    }

    public synchronized void setColorCanvas(Color color) {
        this._colorCanvas.setValue(color);
    }

    public synchronized Color getColorOuterGear() {
        return (Color)this._colorOuterGear.getValue();
    }

    public synchronized void setColorOuterGear(Color color) {
        this._colorOuterGear.setValue(color);
    }

    public synchronized double getFigureAlpha() {
        return this._figureAlpha.doubleValue();
    }

    public synchronized void setFigureAlpha(double d) {
        this._figureAlpha.setDoubleValue(d);
    }

    public synchronized boolean getShowFigureTemporarily() {
        return this._showFigureTemporarily.booleanValue();
    }

    public synchronized void setShowFigureTemporarily(boolean bl) {
        this._showFigureTemporarily.setBooleanValue(bl);
    }

    public synchronized int getInnerRadius() {
        return this._innerRadius.intValue();
    }

    public synchronized void setInnerRadius(int n) {
        this._innerRadius.setIntValue(n);
    }

    public synchronized boolean getInstantUpdate() {
        return this._instantUpdate.booleanValue();
    }

    public synchronized void setInstantUpdate(boolean bl) {
        if (bl) {
            this.setMouseControlled(false);
            this.setAnimated(false);
        }
        this._instantUpdate.setBooleanValue(bl);
    }

    public synchronized double getLambda() {
        return this._lambda.doubleValue();
    }

    public synchronized void setLambda(double d) {
        this._lambda.setDoubleValue(d);
    }

    public synchronized boolean getMouseControlled() {
        return this._mouseControlled.booleanValue();
    }

    public synchronized void setMouseControlled(boolean bl) {
        if (bl) {
            this.setAnimated(false);
            this.setInstantUpdate(false);
        }
        this._mouseControlled.setBooleanValue(bl);
    }

    public synchronized int getOuterRadius() {
        return this._outerRadius.intValue();
    }

    public synchronized void setOuterRadius(int n) {
        this._outerRadius.setIntValue(n);
    }

    public synchronized boolean getShowGears() {
        return this._showGears.booleanValue();
    }

    public synchronized void setShowGears(boolean bl) {
        this._showGears.setBooleanValue(bl);
    }

    public synchronized boolean getShowFigureActually() {
        return this._showFigure.booleanValue() || this._showFigureTemporarily.booleanValue();
    }

    public synchronized boolean getShowFigure() {
        return this._showFigure.booleanValue();
    }

    public synchronized void setShowFigure(boolean bl) {
        this._showFigure.setBooleanValue(bl);
    }

    public synchronized boolean getShowPicture() {
        return this._showPicture.booleanValue();
    }

    public synchronized void setShowPicture(boolean bl) {
        this._showPicture.setBooleanValue(bl);
    }

    public synchronized boolean getAutoFill() {
        return this._autoFill.booleanValue();
    }

    public synchronized void setAutoFill(boolean bl) {
        this._autoFill.setBooleanValue(bl);
    }

    public synchronized int getTimeRound() {
        return this._timeRound.intValue();
    }

    public synchronized void setTimeRound(int n) {
        this._timeRound.setIntValue(n);
    }

    public synchronized boolean getStarted() {
        return this._started.booleanValue();
    }

    public synchronized void setStarted(boolean bl) {
        this._started.setBooleanValue(bl);
    }

    public synchronized boolean getPause() {
        return this._pause.booleanValue();
    }

    public synchronized void setPause(boolean bl) {
        this._pause.setBooleanValue(bl);
    }

    public synchronized boolean getHoldFigure() {
        return this._holdFigure.booleanValue();
    }

    public synchronized void setHoldFigure(boolean bl) {
        this._holdFigure.setBooleanValue(bl);
    }

    public synchronized void setClearFigure(boolean bl) {
        this._clearFigure.setBooleanValue(bl);
    }

    public synchronized void setFillFigure(boolean bl) {
        this._fillFigure.setBooleanValue(bl);
    }

    public synchronized DocModel getDocModel() {
        return (DocModel)this._docModel.getValue();
    }

    public synchronized void setDocModel(DocModel docModel) {
        this._docModel.setValue(docModel);
    }

    private void addPropertySpec(IProperty iProperty) {
        this.propertyHash.put(iProperty.getName(), iProperty);
    }

    private void initPropertySpecs() {
        if (this.propertyHash == null) {
            this.propertyHash = new HashMap();
        }
        this.propertyHash.clear();
        this.addPropertySpec(this._showGears);
        this.addPropertySpec(this._showFigure);
        this.addPropertySpec(this._showPicture);
        this.addPropertySpec(this._autoFill);
        this.addPropertySpec(this._animated);
        this.addPropertySpec(this._mouseControlled);
        this.addPropertySpec(this._instantUpdate);
        this.addPropertySpec(this._showFigureTemporarily);
        this.addPropertySpec(this._holdFigure);
        this.addPropertySpec(this._clearFigure);
        this.addPropertySpec(this._antialiasing);
        this.addPropertySpec(this._timeRound);
        this.addPropertySpec(this._figureAlpha);
        this.addPropertySpec(this._colorFigure);
        this.addPropertySpec(this._colorInnerGear);
        this.addPropertySpec(this._colorOuterGear);
        this.addPropertySpec(this._colorMouseGuide);
        this.addPropertySpec(this._colorCanvas);
        this.addPropertySpec(this._outerRadius);
        this.addPropertySpec(this._innerRadius);
        this.addPropertySpec(this._lambda);
        this.addPropertySpec(this._started);
        this.addPropertySpec(this._pause);
        this.addPropertySpec(this._docModel);
    }

    private void setDefaults() {
        this._animated = new BooleanProperty(ANIMATED, Boolean.FALSE, (IPropertyChangeManager)this);
        this._mouseControlled = new BooleanProperty(MOUSE_CONTROLLED, Boolean.FALSE, (IPropertyChangeManager)this);
        this._instantUpdate = new BooleanProperty(INSTANT_UPDATE, Boolean.TRUE, (IPropertyChangeManager)this);
        this._showFigure = new BooleanProperty(SHOW_FIGURE, Boolean.TRUE, (IPropertyChangeManager)this);
        this._showGears = new BooleanProperty(SHOW_GEARS, Boolean.TRUE, (IPropertyChangeManager)this);
        this._showPicture = new BooleanProperty(SHOW_PICTURE, Boolean.FALSE, (IPropertyChangeManager)this);
        this._showFigureTemporarily = new BooleanProperty(SHOW_FIGURE_TEMPORARILY, Boolean.FALSE, (IPropertyChangeManager)this);
        this._autoFill = new BooleanProperty(AUTO_FILL, Boolean.FALSE, (IPropertyChangeManager)this);
        this._holdFigure = new BooleanProperty(HOLD_FIGURE, Boolean.FALSE, (IPropertyChangeManager)this);
        this._clearFigure = new BooleanActionProperty(CLEAR_FIGURE, Boolean.FALSE, (IPropertyChangeManager)this);
        this._fillFigure = new BooleanActionProperty(FILL_FIGURE, Boolean.FALSE, (IPropertyChangeManager)this);
        this._antialiasing = new BooleanProperty(ANTIALIASING, Boolean.TRUE, (IPropertyChangeManager)this);
        this._timeRound = new IntegerProperty(TIME_ROUND, new Integer(2000), (IPropertyChangeManager)this);
        this._figureAlpha = new DoubleProperty(FIGURE_ALPHA, new Double(1.0), (IPropertyChangeManager)this);
        this._colorFigure = new ColorProperty(COLOR_FIGURE, Color.decode("0x339933"), (IPropertyChangeManager)this);
        this._colorOuterGear = new ColorProperty(COLOR_OUTER_GEAR, Color.decode("0x339933"), (IPropertyChangeManager)this);
        this._colorInnerGear = new ColorProperty(COLOR_INNER_GEAR, Color.decode("0x0066cc"), (IPropertyChangeManager)this);
        this._colorMouseGuide = new ColorProperty(COLOR_MOUSE_GUIDE, Color.decode("0xffc0c0"), (IPropertyChangeManager)this);
        this._colorCanvas = new ColorProperty(COLOR_CANVAS, Color.WHITE, (IPropertyChangeManager)this);
        this._outerRadius = new IntegerProperty(OUTER_RADIUS, new Integer(60), (IPropertyChangeManager)this);
        this._innerRadius = new IntegerProperty(INNER_RADIUS, new Integer(35), (IPropertyChangeManager)this);
        this._lambda = new DoubleProperty(LAMBDA, new Double(0.85), (IPropertyChangeManager)this);
        this._started = new BooleanProperty(STARTED, Boolean.FALSE, (IPropertyChangeManager)this);
        this._pause = new BooleanProperty(PAUSE, Boolean.FALSE, (IPropertyChangeManager)this);
        this._docModel = new GenericProperty<Object>(DOC_MODEL, null, this);
    }

    public void setParameters(Map<String, String> map) {
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            IProperty iProperty = this.propertyHash.get(string);
            try {
                iProperty.parseValue(string2);
            }
            catch (Throwable throwable) {}
        }
    }
}

