/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.math;

public class SpiroMath {
    private final double rBig;
    private final double rSmall;
    private final double lambda;
    private double smallGearCenterX;
    private double smallGearCenterY;
    private double smallGearDirection;
    private double figureX;
    private double figureY;

    public SpiroMath(double d, double d2, double d3) {
        this.rBig = d;
        this.rSmall = d2;
        this.lambda = d3;
    }

    public void calculate(double d) {
        double d2 = -d * this.rBig / this.rSmall;
        double d3 = (this.rBig - this.rSmall) * Math.cos(d);
        double d4 = (this.rBig - this.rSmall) * Math.sin(d);
        double d5 = d3 + this.lambda * this.rSmall * Math.cos(d + d2);
        double d6 = d4 + this.lambda * this.rSmall * Math.sin(d + d2);
        this.smallGearCenterX = d3;
        this.smallGearCenterY = d4;
        this.smallGearDirection = d + d2;
        this.figureX = d5;
        this.figureY = d6;
    }

    public double getFigureX() {
        return this.figureX;
    }

    public double getFigureY() {
        return this.figureY;
    }

    public double getSmallGearCenterX() {
        return this.smallGearCenterX;
    }

    public double getSmallGearCenterY() {
        return this.smallGearCenterY;
    }

    public double getSmallGearDirection() {
        return this.smallGearDirection;
    }
}

