/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.machines;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.machines.AbstractDriver;
import de.admadic.spiromat.machines.DebounceRunner;
import de.admadic.spiromat.machines.Machine;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseControlledDriver
extends AbstractDriver {
    static final Logger logger = Logger.getLogger(MouseControlledDriver.class);
    private MouseMotionListener mouseMotionListener;
    private MouseListener mouseListener;
    private DebounceRunner mouseEventTrigger;
    private final Object mouseEventLock = new Object();
    private int mouseEventX;
    private int mouseEventY;
    private double mouseEventPhi;
    private boolean hasNewEventData = false;
    private final Object calculationLock = new Object();
    private int mousex;
    private int mousey;
    private double targetPhi;

    public MouseControlledDriver(Machine machine) {
        super(machine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMousePos(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        this.machine.getCanvas().transformToCanvasSpace(nArray);
        if (logger.isDebugEnabled()) {
            logger.debug("updM: x=" + n + " y=" + n2 + " a[0]=" + nArray[0] + " a[1]=" + nArray[1]);
        }
        Object object = this.mouseEventLock;
        synchronized (object) {
            this.mouseEventX = nArray[0];
            this.mouseEventY = nArray[1];
            this.mouseEventPhi = this.machine.getKnob().updateKnobFromMousePos(this.mouseEventX, this.mouseEventY);
            this.hasNewEventData = true;
            this.mouseEventTrigger.setHasValue(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyNewMouseData() {
        logger.debug("applyNewMouseData...");
        boolean bl = false;
        Object object = this.mouseEventLock;
        synchronized (object) {
            if (!this.hasNewEventData) {
                return;
            }
            Object object2 = this.calculationLock;
            synchronized (object2) {
                this.mousex = this.mouseEventX;
                this.mousey = this.mouseEventY;
                this.targetPhi = this.mouseEventPhi;
            }
            bl = true;
            this.hasNewEventData = false;
        }
        if (bl) {
            this.machine.renderStep(this.targetPhi, this.mousex, this.mousey);
        }
    }

    @Override
    public void attach() {
        this.mouseEventTrigger = new DebounceRunner(new Runnable(){

            @Override
            public void run() {
                MouseControlledDriver.this.applyNewMouseData();
            }
        }, true);
        this.mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                MouseControlledDriver.this.updateMousePos(mouseEvent.getX(), mouseEvent.getY(), true);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                MouseControlledDriver.this.updateMousePos(mouseEvent.getX(), mouseEvent.getY(), false);
            }
        };
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MouseControlledDriver.this.updateMousePos(mouseEvent.getX(), mouseEvent.getY(), true);
            }
        };
        this.machine.getCanvas().getCanvasComponent().addMouseMotionListener(this.mouseMotionListener);
        this.machine.getCanvas().getCanvasComponent().addMouseListener(this.mouseListener);
    }

    @Override
    public void detach() {
        this.machine.getCanvas().getCanvasComponent().removeMouseMotionListener(this.mouseMotionListener);
        this.machine.getCanvas().getCanvasComponent().removeMouseListener(this.mouseListener);
        this.mouseEventTrigger.stopThread();
    }
}

