/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.machines;

import de.admadic.spiromat.SpiromatException;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.machines.AbstractDriver;
import de.admadic.spiromat.machines.AbstractMachine;
import de.admadic.spiromat.machines.AnimatedDriver;
import de.admadic.spiromat.machines.DebounceRunner;
import de.admadic.spiromat.machines.InstantUpdateDriver;
import de.admadic.spiromat.machines.MouseControlledDriver;
import de.admadic.spiromat.math.SpiroMath;
import de.admadic.spiromat.math.Util;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.model.InnerGearSpec;
import de.admadic.spiromat.model.ModelUtil;
import de.admadic.spiromat.model.OuterGearSpec;
import de.admadic.spiromat.shapes.Drawable;
import de.admadic.spiromat.shapes.FigureView;
import de.admadic.spiromat.shapes.InnerGearView;
import de.admadic.spiromat.shapes.OuterGearView;
import de.admadic.spiromat.ui.SpiromatCanvas;
import de.admadic.spiromat.util.Knob;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Machine
extends AbstractMachine {
    private static final Logger logger = Logger.getLogger(Machine.class);
    private DebounceRunner renderTrigger;
    private HashMap<FigureSpec, FigureView> figureList = new HashMap();
    private FigureView figure;
    private OuterGearView outerGear;
    private InnerGearView innerGear;
    private SpiroMath spiroMath;
    private Knob knob;
    private OuterGearSpec outerGearSpec;
    private InnerGearSpec innerGearSpec;
    private ArrayList<Drawable> drawables = new ArrayList();
    AbstractDriver instantDriver;
    AbstractDriver mouseDriver;
    AbstractDriver animatedDriver;
    AbstractDriver driver;

    public Machine(SpiromatCanvas spiromatCanvas) {
        super(spiromatCanvas);
        logger.debug("created instance");
        this.renderTrigger = new DebounceRunner(new Runnable(){

            @Override
            public void run() {
                Machine.this.renderFull();
            }
        }, true);
        this.instantDriver = new InstantUpdateDriver(this);
        this.mouseDriver = new MouseControlledDriver(this);
        this.animatedDriver = new AnimatedDriver(this);
        this.innerGearSpec = ModelUtil.createStandardInnerGearSpec();
        this.outerGearSpec = ModelUtil.createStandardOuterGearSpec();
        this.installDriver(this.instantDriver, false);
    }

    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public void attachToModel() {
        logger.debug("attaching to model");
        this.outerGear = new OuterGearView(this.outerGearSpec);
        this.innerGear = new InnerGearView(this.innerGearSpec);
        this.spiroMath = ModelUtil.createStandardSpiroMath();
        this.knob = new Knob();
        super.attachToModel();
        this.updateFigureList();
        this.outerGear.setVisible(this.getAppModel().getShowGears());
        this.innerGear.setVisible(this.getAppModel().getShowGears());
        if (this.figure != null) {
            this.figure.setVisible(true);
        }
        this.attachGears();
        this.getCanvas().prepareRender();
        this.renderFull();
    }

    private void updateFigureList() {
        logger.debug("updating figureList");
        DocModel docModel = this.getDocModel();
        this.figureList.clear();
        this.drawables.clear();
        this.figure = null;
        int n = docModel.getFigureSpecCount();
        int n2 = docModel.getActiveFigureIndex();
        for (int i = 0; i < n; ++i) {
            FigureSpec figureSpec = docModel.getFigureSpec(i);
            FigureView figureView = new FigureView(figureSpec);
            this.figureList.put(figureSpec, figureView);
            if (i == n2 && !AppModel.getInstance().getShowPicture()) {
                this.figure = figureView;
                continue;
            }
            this.drawables.add(figureView);
        }
        if (!AppModel.getInstance().getShowPicture()) {
            if (this.figure != null) {
                this.drawables.add(this.figure);
            }
            this.drawables.add(this.outerGear);
            this.drawables.add(this.innerGear);
        }
    }

    private void updateViewStatus() {
        boolean bl = this.getAppModel().getShowFigure();
        if (this.getAppModel().getShowPicture()) {
            bl = true;
        }
        for (FigureView figureView : this.figureList.values()) {
            if (figureView == this.figure) continue;
            figureView.setVisible(bl);
        }
        if (this.figure != null) {
            this.figure.setVisible(true);
        }
    }

    @Override
    public void detachFromModel() {
        logger.debug("detaching from model");
        super.detachFromModel();
        this.figureList.clear();
        this.drawables.clear();
        this.outerGear = null;
        this.innerGear = null;
        this.figure = null;
        this.spiroMath = null;
        this.knob = null;
    }

    private void installDriver(AbstractDriver abstractDriver, boolean bl) {
        logger.debug("installing new driver");
        AbstractDriver abstractDriver2 = this.driver;
        this.driver = abstractDriver;
        if (abstractDriver2 != null) {
            abstractDriver2.detach();
        }
        if (abstractDriver != null) {
            abstractDriver.attach();
        }
    }

    public Knob getKnob() {
        return this.knob;
    }

    public SpiroMath getSpiroMath() {
        return this.spiroMath;
    }

    @Override
    public void pauseMachine() {
        logger.debug("pauseMachine");
    }

    @Override
    public void resetMachine() {
        logger.debug("resetMachine");
    }

    @Override
    public void startMachine() {
        logger.debug("startMachine");
    }

    @Override
    public void stopMachine() {
        logger.debug("stopMachine");
    }

    @Override
    public void continueMachine() {
        logger.debug("continueMachine");
    }

    @Override
    public void destroyMachine() {
        logger.debug("destroyMachine");
        this.renderTrigger.stopThread();
    }

    public void renderFull() {
        int n = Util.calculateRounds(this.getAppModel().getOuterRadius(), this.getAppModel().getInnerRadius());
        logger.debug("renderFull: (using " + n + " rounds)");
        if (!this.getAppModel().getHoldFigure()) {
            logger.debug("calling canvas.resetRender");
            this.getCanvas().resetRender();
            this.attachGears();
        }
        logger.debug("calling canvas.clear");
        this.getCanvas().clear();
        logger.debug("calling canvas.render");
        this.getCanvas().render(this.getDrawables());
    }

    public void renderUpdate() {
        int n = Util.calculateRounds(this.getAppModel().getOuterRadius(), this.getAppModel().getInnerRadius());
        logger.debug("renderUpdate: (using " + n + " rounds)");
        if (!this.getAppModel().getHoldFigure()) {
            logger.debug("calling canvas.resetRender");
            this.getCanvas().resetRender();
        }
        logger.debug("calling canvas.clear");
        this.getCanvas().clear();
        logger.debug("calling canvas.render");
        this.getCanvas().render(this.getDrawables());
    }

    protected void renderStep(double d, int n, int n2) {
        if (logger.isDebugEnabled()) {
            logger.debug("renderStep: mouse=" + n + " / " + n2 + " phi=" + d);
        }
        this.spiroMath.calculate(d);
        this.getDocModel().getActiveFigureSpec().setCursorAngle(d);
        this.outerGear.setState(0.0, 0.0, 0.0);
        this.innerGear.setState(this.spiroMath.getSmallGearDirection(), this.spiroMath.getSmallGearCenterX(), this.spiroMath.getSmallGearCenterY());
        logger.debug("calling canvas.render");
        this.getCanvas().render(this.getDrawables());
    }

    private void attachGears() {
        logger.debug("attaching gears");
        FigureSpec figureSpec = this.getDocModel().getActiveFigureSpec();
        if (figureSpec != null) {
            this.spiroMath = ModelUtil.createStandardSpiroMath(this.getDocModel());
            double d = 0.0;
            if (AppModel.getInstance().getAutoFill()) {
                figureSpec.initFullInterval();
            }
            d = figureSpec.getCursorAngle();
            logger.debug("attaching inner gear for phi=" + d);
            this.spiroMath.calculate(d);
            this.outerGearSpec.updateFromFigureSpec(figureSpec);
            this.innerGearSpec.updateFromFigureSpec(figureSpec);
            this.innerGear.setState(this.spiroMath.getSmallGearDirection(), this.spiroMath.getSmallGearCenterX(), this.spiroMath.getSmallGearCenterY());
            this.knob.setAngle(d);
        }
    }

    @Override
    public void appPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            logger.debug("app prop change: " + string);
            if (string.equals("showGears")) {
                this.innerGear.setVisible(this.getAppModel().getShowGears());
                this.outerGear.setVisible(this.getAppModel().getShowGears());
                this.renderTrigger.setHasValue(true);
            } else if (string.equals("showFigureTemporarily")) {
                if (this.figure != null) {
                    this.figure.setVisible(this.getAppModel().getShowFigureActually());
                }
            } else if (string.equals("showFigure")) {
                this.updateViewStatus();
                this.getCanvas().clear();
                this.renderTrigger.setHasValue(true);
            } else if (string.equals("showPicture")) {
                this.updateFigureList();
                this.updateViewStatus();
                this.renderFull();
            } else if (string.equals("animated")) {
                if (this.getAppModel().getAnimated()) {
                    this.installDriver(this.animatedDriver, true);
                    this.getAppModel().setHoldFigure(false);
                    this.getAppModel().setShowFigureTemporarily(true);
                    if (!this.getAppModel().getShowGears()) {
                        this.getAppModel().setShowGears(true);
                    }
                }
            } else if (string.equals("mouseControlled")) {
                if (this.getAppModel().getMouseControlled()) {
                    this.installDriver(this.mouseDriver, true);
                    this.getAppModel().setHoldFigure(false);
                    this.getAppModel().setShowFigureTemporarily(true);
                    if (!this.getAppModel().getShowGears()) {
                        this.getAppModel().setShowGears(true);
                    }
                }
            } else if (string.equals("instantUpdate")) {
                if (this.getAppModel().getInstantUpdate()) {
                    this.installDriver(this.instantDriver, false);
                    this.renderUpdate();
                }
            } else if (string.equals("holdFigure")) {
                if (this.getAppModel().getInstantUpdate() && ((Boolean)propertyChangeEvent.getOldValue()).booleanValue() && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.getAppModel().setShowFigureTemporarily(false);
                    this.renderFull();
                }
            } else if (string.equals("clearFigure")) {
                this.getDocModel().getActiveFigureSpec().clear();
                this.getKnob().reset();
                this.attachGears();
                this.renderUpdate();
            } else if (string.equals("fillFigure")) {
                this.getDocModel().getActiveFigureSpec().initFullInterval();
                this.renderFull();
            } else if (string.equals("autoFill")) {
                logger.debug("autoFill: iu=" + this.getAppModel().getInstantUpdate() + " ov=" + propertyChangeEvent.getOldValue() + " nv=" + propertyChangeEvent.getNewValue());
                if (this.getAppModel().getInstantUpdate() && !((Boolean)propertyChangeEvent.getOldValue()).booleanValue() && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    logger.debug("auto fill turned on");
                    FigureSpec figureSpec = this.getDocModel().getActiveFigureSpec();
                    if (figureSpec.getEndAngle() - figureSpec.getStartAngle() == 0.0) {
                        logger.debug("empty figure detected, filling");
                        figureSpec.initFullInterval();
                        this.renderFull();
                    }
                }
            } else if (string.equals("docModel")) {
                this.updateFigureList();
                FigureSpec figureSpec = this.getDocModel().getActiveFigureSpec();
                if (logger.isDebugEnabled()) {
                    logger.debug("active figure: index=" + this.getDocModel().getActiveFigureIndex() + "phi=" + (Serializable)(figureSpec != null ? Double.valueOf(figureSpec.getCursorAngle()) : "<null>"));
                }
                this.figure = figureSpec != null ? this.figureList.get(figureSpec) : null;
                this.attachGears();
                this.renderUpdate();
            } else {
                logger.debug("unhandled property " + string + " changed.");
            }
        } else {
            throw new SpiromatException("Cannot yet handle unspecified PropertyChangeEvents");
        }
    }

    @Override
    public void docPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            logger.debug("doc propChange: " + string);
            if (string.equals("figureList")) {
                this.updateFigureList();
                this.updateViewStatus();
            } else if (string.equals("activeFigure")) {
                if (logger.isDebugEnabled()) {
                    FigureSpec figureSpec = this.getDocModel().getActiveFigureSpec();
                    logger.debug("active figure: index=" + this.getDocModel().getActiveFigureIndex() + "phi=" + (Serializable)(figureSpec != null ? Double.valueOf(figureSpec.getCursorAngle()) : "<null>"));
                }
                this.updateFigureList();
                this.updateViewStatus();
                this.attachGears();
                this.renderUpdate();
            }
        }
    }

    @Override
    public void figPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            logger.debug("fig propChange: " + string);
        }
    }
}

