/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.machines;

import de.admadic.spiromat.SpiromatException;
import de.admadic.spiromat.log.Logger;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;

public class DebounceRunner
implements Runnable {
    static final Logger logger = Logger.getLogger(DebounceRunner.class);
    private volatile Thread thread;
    private volatile boolean hasValue;
    private Runnable task;
    private boolean inEDT;
    private int holdOffTime = 50;

    public DebounceRunner(Runnable runnable, boolean bl) {
        this.task = runnable;
        this.inEDT = bl;
        this.thread = new Thread((Runnable)this, "DebounceRunner");
        this.thread.setPriority(4);
        this.thread.setDaemon(true);
        logger.debug("starting thread...");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.thread == Thread.currentThread()) {
            DebounceRunner debounceRunner = this;
            synchronized (debounceRunner) {
                if (!this.hasValue) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug("InterruptedException caught, breaking...");
                        break;
                    }
                }
            }
            if (!this.hasValue) continue;
            debounceRunner = this;
            synchronized (debounceRunner) {
                this.hasValue = false;
            }
            logger.debug("woke up and got value");
            if (!this.inEDT || EventQueue.isDispatchThread()) {
                logger.debug("simple fire");
                this.task.run();
            } else {
                logger.debug("invokeAndWait fire");
                try {
                    EventQueue.invokeAndWait(this.task);
                }
                catch (InterruptedException interruptedException) {
                    logger.debug("InterruptedException caught, breaking...");
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new SpiromatException(invocationTargetException);
                }
            }
            try {
                Thread.sleep(this.holdOffTime);
            }
            catch (InterruptedException interruptedException) {
                logger.debug("InterruptedException caught, breaking...");
                break;
            }
        }
    }

    public synchronized boolean isHasValue() {
        return this.hasValue;
    }

    public synchronized void setHasValue(boolean bl) {
        this.hasValue = bl;
        this.notifyAll();
    }

    public void stopThread() {
        if (this.thread != null) {
            logger.debug("stopping thread (interrupting)...");
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public int getHoldOffTime() {
        return this.holdOffTime;
    }

    public void setHoldOffTime(int n) {
        this.holdOffTime = n;
    }
}

