/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.machines;

import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.machines.AbstractDriver;
import de.admadic.spiromat.machines.Machine;
import de.admadic.spiromat.math.Util;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.FigureSpec;
import javax.swing.SwingUtilities;

public class AnimatedDriver
extends AbstractDriver
implements Runnable {
    private static final Logger logger = Logger.getLogger(AnimatedDriver.class);
    private volatile Thread tickerThread;
    private double lastPhi;
    private double endPhi;
    private static final int TIME_SLICE = 50;

    public AnimatedDriver(Machine machine) {
        super(machine);
    }

    @Override
    public void attach() {
        logger.debug("attach...");
        this.lastPhi = 0.0;
        this.updateEndPhi();
        this.setToCursor();
        this.tickerThread = new Thread((Runnable)this, "AnimatedDriver");
        logger.debug("starting thread...");
        this.tickerThread.start();
    }

    private void setToCursor() {
        FigureSpec figureSpec = AppModel.getInstance().getDocModel().getActiveFigureSpec();
        double d = figureSpec.getCursorAngle();
        if (d < 0.0) {
            this.endPhi = 0.0 - this.endPhi;
        }
        this.lastPhi = d;
    }

    @Override
    public void detach() {
        logger.debug("detach...");
        Thread thread = this.tickerThread;
        this.tickerThread = null;
        logger.debug("interrupt...");
        thread.interrupt();
    }

    private void updateEndPhi() {
        int n = Util.calculateRounds(AppModel.getInstance().getOuterRadius(), AppModel.getInstance().getInnerRadius());
        this.endPhi = (double)n * Math.PI * 2.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("ticker thread started");
        long l = System.currentTimeMillis();
        long l2 = -1L;
        Thread thread = Thread.currentThread();
        while (thread == this.tickerThread) {
            l2 = System.currentTimeMillis();
            if (l2 - l < 50L) {
                try {
                    logger.debug("sleep...");
                    Thread.sleep(50L);
                    logger.debug("sleep done...");
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    logger.debug("InterruptedException caught, breaking...");
                    break;
                }
                finally {
                    logger.debug("sleep (finally)...");
                    continue;
                }
            }
            logger.debug("getTimeRound...");
            double d = (double)(l2 - l) * Math.PI * 2.0 / (double)AppModel.getInstance().getTimeRound();
            logger.debug("getTimeRound done...");
            l = l2;
            if (this.endPhi < 0.0) {
                d = -d;
            }
            if (this.endPhi > 0.0 && this.lastPhi < this.endPhi || this.endPhi < 0.0 && this.lastPhi > this.endPhi) {
                this.lastPhi += d;
                if (Thread.interrupted()) {
                    logger.debug("interrupted, breaking...");
                    break;
                }
                logger.debug("renderStep...");
                this.machine.renderStep(this.lastPhi, 0, 0);
                logger.debug("renderStep done...");
                continue;
            }
            logger.debug("signalling stop...");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppModel.getInstance().setStarted(false);
                }
            });
        }
        logger.debug("ticker thread stopped");
    }
}

