/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.machines;

import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.ModelPropertyChangeListener;
import de.admadic.spiromat.model.ModelPropertyChangeSupport;
import de.admadic.spiromat.ui.SpiromatCanvas;
import java.beans.PropertyChangeEvent;

public abstract class AbstractMachine
implements ModelPropertyChangeListener {
    private SpiromatCanvas canvasRef;
    ModelPropertyChangeSupport modelPropSupport = new ModelPropertyChangeSupport(this);

    public AbstractMachine(SpiromatCanvas spiromatCanvas) {
        this.canvasRef = spiromatCanvas;
    }

    public AppModel getAppModel() {
        return AppModel.getInstance();
    }

    public DocModel getDocModel() {
        return AppModel.getInstance().getDocModel();
    }

    public SpiromatCanvas getCanvas() {
        return this.canvasRef;
    }

    public abstract void startMachine();

    public abstract void stopMachine();

    public abstract void pauseMachine();

    public abstract void continueMachine();

    public abstract void resetMachine();

    public abstract void destroyMachine();

    public void attachToModel() {
        this.modelPropSupport.attachToAppModel();
    }

    public void detachFromModel() {
        this.modelPropSupport.detachFromAppModel();
    }

    @Override
    public abstract void appPropertyChange(PropertyChangeEvent var1);

    @Override
    public abstract void docPropertyChange(PropertyChangeEvent var1);

    @Override
    public abstract void figPropertyChange(PropertyChangeEvent var1);
}

