/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.log;

import de.admadic.spiromat.log.ILogger;
import de.admadic.spiromat.log.NullLogger;
import java.lang.reflect.Method;
import java.security.AccessControlException;

public class Logger
implements ILogger {
    private static String loggerClassName = null;
    private static Class<?> loggerClass = null;
    private static final String LOGGER_PROPNAME = "de.admadic.spiromat.log.loggerClass";
    private static final String NULL_LOGGER_CLASSNAME = "de.admadic.spiromat.log.NullLogger";
    private Class<?> loggedClass = null;
    private ILogger loggerDelegate = null;

    public static void initialize() {
        try {
            loggerClassName = System.getProperty(LOGGER_PROPNAME, NULL_LOGGER_CLASSNAME);
            loggerClass = Class.forName(loggerClassName);
        }
        catch (AccessControlException accessControlException) {
            loggerClass = NullLogger.class;
        }
        catch (ClassNotFoundException classNotFoundException) {
            loggerClass = NullLogger.class;
        }
        try {
            Method method = loggerClass.getMethod("initialize", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            loggerClassName = NULL_LOGGER_CLASSNAME;
            loggerClass = NullLogger.class;
        }
    }

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz);
    }

    protected Logger(Class<?> clazz) {
        this.loggedClass = clazz;
        try {
            Method method = loggerClass.getMethod("getLogger", Class.class);
            this.loggerDelegate = (ILogger)method.invoke(null, this.loggedClass);
        }
        catch (Throwable throwable) {
            this.loggerDelegate = NullLogger.getLogger(clazz);
        }
        if (this.loggerDelegate == null) {
            this.loggerDelegate = NullLogger.getLogger(clazz);
        }
    }

    @Override
    public void debug(Object object, Throwable throwable) {
        this.loggerDelegate.debug(object, throwable);
    }

    @Override
    public void debug(Object object) {
        this.loggerDelegate.debug(object);
    }

    @Override
    public void error(Object object, Throwable throwable) {
        this.loggerDelegate.error(object, throwable);
    }

    @Override
    public void error(Object object) {
        this.loggerDelegate.error(object);
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        this.loggerDelegate.fatal(object, throwable);
    }

    @Override
    public void fatal(Object object) {
        this.loggerDelegate.fatal(object);
    }

    @Override
    public void info(Object object, Throwable throwable) {
        this.loggerDelegate.info(object, throwable);
    }

    @Override
    public void info(Object object) {
        this.loggerDelegate.info(object);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.loggerDelegate.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.loggerDelegate.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.loggerDelegate.isTraceEnabled();
    }

    @Override
    public void trace(Object object, Throwable throwable) {
        this.loggerDelegate.trace(object, throwable);
    }

    @Override
    public void trace(Object object) {
        this.loggerDelegate.trace(object);
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        this.loggerDelegate.warn(object, throwable);
    }

    @Override
    public void warn(Object object) {
        this.loggerDelegate.warn(object);
    }
}

