/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.actions;

import de.admadic.spiromat.actions.ActionFactory;
import de.admadic.spiromat.actions.Messages;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.io.DocumentWriter;
import de.admadic.spiromat.model.io.SpiromatIOException;
import de.admadic.spiromat.ui.BackgroundManager;
import de.admadic.spiromat.ui.BackgroundWaitDialog;
import de.admadic.spiromat.ui.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SaveDocAction
extends AbstractAction {
    static Logger logger = Logger.getLogger(SaveDocAction.class);
    private static final long serialVersionUID = 1L;

    public SaveDocAction() {
        this.putValue("Name", Messages.getString("SaveDocAction.name"));
        this.putValue("ShortDescription", Messages.getString("SaveDocAction.shortDesc"));
        this.putValue("SmallIcon", Util.loadButtonImage("save.png"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DocModel docModel = AppModel.getInstance().getDocModel();
        if (docModel.getFile() == null) {
            Action action = ActionFactory.get("saveAsDoc");
            action.actionPerformed(actionEvent);
        } else {
            Object object;
            JFrame jFrame = null;
            if (actionEvent.getSource() instanceof Component && (object = SwingUtilities.getRoot((Component)actionEvent.getSource())) instanceof JFrame) {
                jFrame = (JFrame)object;
            }
            object = new Worker(docModel, docModel.getFile(), jFrame);
            ((Worker)object).execute();
            BackgroundWaitDialog backgroundWaitDialog = new BackgroundWaitDialog(jFrame);
            backgroundWaitDialog.setCancelEnabled(false);
            backgroundWaitDialog.execute();
        }
    }

    protected static void showSaveError(final JFrame jFrame, final File file, final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = MessageFormat.format(Messages.getString("SaveDocAction.saveErrorMsg"), file.getName(), file.getParent() == null ? Messages.getString("SaveDocAction.unknownDir") : file.getParent(), exception.getLocalizedMessage());
                JOptionPane.showMessageDialog(jFrame, string, Messages.getString("SaveDocAction.saveErrorTitle"), 0);
            }
        });
    }

    static class Worker
    implements Runnable {
        AppModel appModel;
        DocModel docModel;
        File file;
        JFrame parent;

        public Worker(DocModel docModel, File file, JFrame jFrame) {
            this.docModel = docModel;
            this.file = file;
            this.parent = jFrame;
        }

        public void execute() {
            Thread thread = new Thread((Runnable)this, "save-thread");
            thread.setDaemon(true);
            BackgroundManager.getInstance().addTask(this);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DocumentWriter documentWriter = new DocumentWriter(this.docModel);
                boolean bl = false;
                SpiromatIOException spiromatIOException = null;
                try {
                    documentWriter.write();
                    bl = true;
                }
                catch (SpiromatIOException spiromatIOException2) {
                    logger.error("save error", spiromatIOException2);
                    spiromatIOException = spiromatIOException2;
                    bl = false;
                }
                final boolean bl2 = bl;
                final SpiromatIOException spiromatIOException3 = spiromatIOException;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (bl2) {
                            docModel.setDirty(false);
                        } else {
                            SaveDocAction.showSaveError(parent, docModel.getFile(), spiromatIOException3);
                        }
                    }
                });
            }
            finally {
                BackgroundManager.getInstance().markDone(this);
            }
        }
    }
}

