/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.actions;

import de.admadic.spiromat.actions.ActionFactory;
import de.admadic.spiromat.actions.Messages;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.ui.FileChooserProvider;
import de.admadic.spiromat.ui.Util;
import de.admadic.spiromat.util.FileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SaveAsDocAction
extends AbstractAction {
    static Logger logger = Logger.getLogger(SaveAsDocAction.class);
    private static final long serialVersionUID = 1L;

    public SaveAsDocAction() {
        this.putValue("Name", Messages.getString("SaveAsDocAction.name"));
        this.putValue("ShortDescription", Messages.getString("SaveAsDocAction.shortDesc"));
        this.putValue("SmallIcon", Util.loadButtonImage("saveas.png"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        DocModel docModel = AppModel.getInstance().getDocModel();
        JFrame jFrame = null;
        if (actionEvent.getSource() instanceof Component && (serializable = SwingUtilities.getRoot((Component)actionEvent.getSource())) instanceof JFrame) {
            jFrame = (JFrame)serializable;
        }
        serializable = null;
        JFileChooser jFileChooser = FileChooserProvider.getFileChooser();
        FileChooserProvider.setSpmFilter(jFileChooser);
        jFileChooser.setSelectedFile(null);
        while (true) {
            int n;
            if ((n = jFileChooser.showSaveDialog(jFrame)) != 0) {
                return;
            }
            serializable = jFileChooser.getSelectedFile();
            if (!((File)(serializable = FileUtil.tryToAppendExtension((File)serializable, ".spm", true))).exists()) break;
            Object[] objectArray = new String[]{Messages.getString("SaveAsDocAction.optionLabelOverwrite"), Messages.getString("SaveAsDocAction.optionLabelChooseOther"), Messages.getString("SaveAsDocAction.optionLabelCancel")};
            String string = MessageFormat.format(Messages.getString("SaveAsDocAction.fileExistsErrorMsg1") + Messages.getString("SaveAsDocAction.fileExistsErrorMsg2"), ((File)serializable).getName(), ((File)serializable).getParent() == null ? Messages.getString("SaveAsDocAction.unknownDir") : ((File)serializable).getParent());
            n = JOptionPane.showOptionDialog(jFrame, string, Messages.getString("SaveAsDocAction.fileExistsErrorTitle"), 1, 3, null, objectArray, objectArray[1]);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        docModel.setFile((File)serializable);
        Action action = ActionFactory.get("saveDoc");
        action.actionPerformed(actionEvent);
    }
}

