/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.actions;

import de.admadic.spiromat.actions.ActionFactory;
import de.admadic.spiromat.actions.Messages;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.io.DocumentReader;
import de.admadic.spiromat.model.io.SpiromatIOException;
import de.admadic.spiromat.ui.FileChooserProvider;
import de.admadic.spiromat.ui.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class OpenDocAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public OpenDocAction() {
        this.putValue("Name", Messages.getString("OpenDocAction.name"));
        this.putValue("ShortDescription", Messages.getString("OpenDocAction.shortDesc"));
        this.putValue("SmallIcon", Util.loadButtonImage("open.png"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object[] objectArray;
        Serializable serializable;
        JFrame jFrame = null;
        if (actionEvent.getSource() instanceof Component && (serializable = SwingUtilities.getRoot((Component)actionEvent.getSource())) instanceof JFrame) {
            jFrame = (JFrame)serializable;
        }
        if ((serializable = AppModel.getInstance().getDocModel()) != null && ((DocModel)serializable).isDirty()) {
            objectArray = new String[]{Messages.getString("OpenDocAction.optionLabelSave"), Messages.getString("OpenDocAction.optionLabelOpenOther"), Messages.getString("OpenDocAction.optionLabelCancel")};
            n = JOptionPane.showOptionDialog(null, Messages.getString("OpenDocAction.notSavedErrorMsg1") + Messages.getString("OpenDocAction.notSavedErrorMsg2"), Messages.getString("OpenDocAction.notSavedErrorTitle"), 1, 3, null, objectArray, objectArray[2]);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                ActionFactory.get("saveDoc").actionPerformed(actionEvent);
            }
        }
        objectArray = FileChooserProvider.getFileChooser();
        FileChooserProvider.setSpmFilter((JFileChooser)objectArray);
        n = objectArray.showOpenDialog(jFrame);
        if (n != 0) {
            return;
        }
        File file = objectArray.getSelectedFile();
        DocumentReader documentReader = new DocumentReader(file);
        try {
            documentReader.read();
            DocModel docModel = documentReader.getDocModel();
            docModel.setFile(file);
            AppModel.getInstance().setDocModel(docModel);
        }
        catch (SpiromatIOException spiromatIOException) {
            JOptionPane.showMessageDialog(jFrame, Messages.getString("OpenDocAction.fileCreateErrorMsg"), Messages.getString("OpenDocAction.fileCreateErrorTitle"), 0);
        }
    }
}

