/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.actions;

import de.admadic.spiromat.SpiromatException;
import de.admadic.spiromat.actions.Messages;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.model.DocModel;
import de.admadic.spiromat.model.FigureSpec;
import de.admadic.spiromat.ui.BackgroundManager;
import de.admadic.spiromat.ui.FileChooserProvider;
import de.admadic.spiromat.ui.Util;
import de.admadic.spiromat.util.BitmapExport;
import de.admadic.spiromat.util.FileExport;
import de.admadic.spiromat.util.FileUtil;
import de.admadic.spiromat.util.SvgExport;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SerializationUtils;

public class ExportDocAction
extends AbstractAction {
    static Logger logger = Logger.getLogger(ExportDocAction.class);
    private static final long serialVersionUID = 1L;

    public ExportDocAction() {
        this.putValue("Name", Messages.getString("ExportDocAction.name"));
        this.putValue("ShortDescription", Messages.getString("ExportDocAction.shortDesc"));
        this.putValue("SmallIcon", Util.loadButtonImage("export.png"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object[] objectArray;
        Serializable serializable;
        DocModel docModel = AppModel.getInstance().getDocModel();
        JFrame jFrame = null;
        if (actionEvent.getSource() instanceof Component && (serializable = SwingUtilities.getRoot((Component)actionEvent.getSource())) instanceof JFrame) {
            jFrame = (JFrame)serializable;
        }
        serializable = null;
        JFileChooser jFileChooser = FileChooserProvider.getFileChooser();
        FileChooserProvider.setExportsFilter(jFileChooser);
        if (docModel.getFile() != null) {
            jFileChooser.setSelectedFile(new File(FilenameUtils.removeExtension(docModel.getFile().getName())));
        } else if (jFileChooser.getSelectedFile() != null) {
            jFileChooser.setSelectedFile(new File(FilenameUtils.removeExtension(jFileChooser.getSelectedFile().getName())));
        }
        block5: while (true) {
            int n;
            if ((n = jFileChooser.showSaveDialog(jFrame)) != 0) {
                return;
            }
            serializable = jFileChooser.getSelectedFile();
            serializable = FileChooserProvider.fixupExtension(jFileChooser, (File)serializable);
            if (!FileUtil.hasExtension((File)(serializable = FileUtil.stripQuotes((File)serializable)), new String[]{".png", ".jpg", ".svg"}, true)) {
                JOptionPane.showMessageDialog(jFrame, Messages.getString("ExportDocAction.missingExtensionError") + ((File)serializable).toString() + "\n" + Messages.getString("ExportDocAction.missingExtensionInfo"), Messages.getString("ExportDocAction.missingExtensionTitle"), 2);
                continue;
            }
            if (!((File)serializable).exists()) break;
            objectArray = new String[]{Messages.getString("ExportDocAction.optionLabelOverwrite"), Messages.getString("ExportDocAction.optionLabelChooseOther"), Messages.getString("ExportDocAction.optionLabelCancel")};
            object = MessageFormat.format(Messages.getString("ExportDocAction.fileExistsError"), ((File)serializable).getName(), ((File)serializable).getParent() == null ? Messages.getString("ExportDocAction.unknownDirectory") : ((File)serializable).getParent());
            n = JOptionPane.showOptionDialog(jFrame, object, Messages.getString("ExportDocAction.fileExistsTitle"), 1, 3, null, objectArray, objectArray[1]);
            switch (n) {
                case 0: {
                    break block5;
                }
                case 1: {
                    continue block5;
                }
                case 2: {
                    return;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        FigureSpec figureSpec = (FigureSpec)SerializationUtils.clone(docModel.getActiveFigureSpec());
        objectArray = SerializationUtils.serialize(docModel);
        object = (DocModel)SerializationUtils.deserialize(objectArray);
        Worker worker = new Worker((DocModel)object, (File)serializable, jFrame);
        worker.execute();
    }

    protected static void showSaveError(final JFrame jFrame, final File file, final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = MessageFormat.format(Messages.getString("ExportDocAction.exportErrorMessage"), file.getName(), file.getParent() == null ? Messages.getString("ExportDocAction.exportErrorUnknownDir") : file.getParent(), exception.getLocalizedMessage());
                JOptionPane.showMessageDialog(jFrame, string, Messages.getString("ExportDocAction.exportErrorTitle"), 2);
            }
        });
    }

    static class Worker
    implements Runnable {
        DocModel docModel;
        File file;
        JFrame parent;

        public Worker(DocModel docModel, File file, JFrame jFrame) {
            this.docModel = docModel;
            this.file = file;
            this.parent = jFrame;
        }

        public void execute() {
            Thread thread = new Thread((Runnable)this, "export-thread");
            thread.setDaemon(true);
            BackgroundManager.getInstance().addTask(this);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    File file = this.file;
                    String string = file.getName();
                    string = string.toLowerCase();
                    if (string.endsWith(".png")) {
                        BitmapExport bitmapExport = new BitmapExport(this.docModel);
                        BufferedImage bufferedImage = bitmapExport.export();
                        try {
                            FileExport.export(bufferedImage, file, FileExport.Format.PNG);
                        }
                        catch (IOException iOException) {
                            logger.error("export error", iOException);
                            ExportDocAction.showSaveError(this.parent, file, iOException);
                        }
                        break block13;
                    }
                    if (string.endsWith(".jpg")) {
                        BitmapExport bitmapExport = new BitmapExport(this.docModel, Color.WHITE);
                        BufferedImage bufferedImage = bitmapExport.export();
                        try {
                            FileExport.export(bufferedImage, file, FileExport.Format.JPEG);
                        }
                        catch (IOException iOException) {
                            logger.error("export error", iOException);
                            ExportDocAction.showSaveError(this.parent, file, iOException);
                        }
                        break block13;
                    }
                    if (string.endsWith(".svg")) {
                        SvgExport svgExport = new SvgExport(this.docModel);
                        try {
                            svgExport.export(file);
                        }
                        catch (IOException iOException) {
                            logger.error("export error", iOException);
                            ExportDocAction.showSaveError(this.parent, file, iOException);
                        }
                        catch (Exception exception) {
                            logger.error("export error", exception);
                            ExportDocAction.showSaveError(this.parent, file, exception);
                        }
                        break block13;
                    }
                    throw new SpiromatException("The extension should have been blocked earlier");
                }
                finally {
                    BackgroundManager.getInstance().markDone(this);
                }
            }
        }
    }
}

