/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat.actions;

import de.admadic.spiromat.actions.AboutAction;
import de.admadic.spiromat.actions.AddFigureAction;
import de.admadic.spiromat.actions.AnimateAction;
import de.admadic.spiromat.actions.AntialiasAction;
import de.admadic.spiromat.actions.AutoFillAction;
import de.admadic.spiromat.actions.ClearAction;
import de.admadic.spiromat.actions.CloseAction;
import de.admadic.spiromat.actions.ExportDocAction;
import de.admadic.spiromat.actions.FillAction;
import de.admadic.spiromat.actions.InnerRadiusValueAction;
import de.admadic.spiromat.actions.MouseControlledAction;
import de.admadic.spiromat.actions.MoveFigureDownAction;
import de.admadic.spiromat.actions.MoveFigureUpAction;
import de.admadic.spiromat.actions.NewDocAction;
import de.admadic.spiromat.actions.OpenDocAction;
import de.admadic.spiromat.actions.OuterRadiusValueAction;
import de.admadic.spiromat.actions.PenHolePosValueAction;
import de.admadic.spiromat.actions.RemoveFigureAction;
import de.admadic.spiromat.actions.SaveAsDocAction;
import de.admadic.spiromat.actions.SaveDocAction;
import de.admadic.spiromat.actions.ShowFigureAction;
import de.admadic.spiromat.actions.ShowGearsAction;
import de.admadic.spiromat.actions.ShowPictureAction;
import de.admadic.spiromat.log.Logger;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.Action;

public class ActionFactory {
    static Logger logger = Logger.getLogger(ActionFactory.class);
    private static HashMap<String, Action> actions = new HashMap();
    public static final String ABOUT_ACTION = "about";
    public static final String NEW_DOC_ACTION = "newDoc";
    public static final String OPEN_DOC_ACTION = "openDoc";
    public static final String SAVE_DOC_ACTION = "saveDoc";
    public static final String SAVE_AS_DOC_ACTION = "saveAsDoc";
    public static final String EXPORT_DOC_ACTION = "exportDoc";
    public static final String ADD_FIGURE_ACTION = "addFigure";
    public static final String REMOVE_FIGURE_ACTION = "removeFigure";
    public static final String MOVE_FIGURE_UP_ACTION = "moveFigureUp";
    public static final String MOVE_FIGURE_DOWN_ACTION = "moveFigureDown";
    public static final String ANIMATE_ACTION = "animate";
    public static final String MOUSE_CONTROLLED_ACTION = "mouseControlled";
    public static final String CLEAR_ACTION = "clear";
    public static final String FILL_ACTION = "fill";
    public static final String CLOSE_ACTION = "close";
    public static final String SHOW_PICTURE_ACTION = "showPicture";
    public static final String SHOW_FIGURE_ACTION = "showFigure";
    public static final String SHOW_GEARS_ACTION = "showGears";
    public static final String AUTO_FILL_ACTION = "autoFill";
    public static final String ANTIALIAS_ACTION = "antialias";
    public static final String OUTER_GEAR_VALUE_ACTION = "outerGearValue";
    public static final String INNER_GEAR_VALUE_ACTION = "innerGearValue";
    public static final String PEN_HOLE_POS_VALUE_ACTION = "penHolePosValue";
    private static HashMap<String, Class<? extends Action>> actionClasses = new HashMap();

    public static Action create(String string) {
        Class<? extends Action> clazz = actionClasses.get(string);
        if (clazz == null) {
            logger.error("no class registered for action with id " + string);
            throw new Error("no class registered for action with id " + string);
        }
        Action action = null;
        try {
            action = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.error("error instantiating Action class for id " + string, instantiationException);
            throw new Error("error instantiating Action class for id " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("error instantiating Action class for id " + string, illegalAccessException);
            throw new Error("error instantiating Action class for id " + string, illegalAccessException);
        }
        return action;
    }

    public static Action get(String string) {
        if (!actions.containsKey(string)) {
            actions.put(string, ActionFactory.create(string));
        }
        return actions.get(string);
    }

    public static ActionEvent createEvent(Object object, String string) {
        return new ActionEvent(object, 2000, string);
    }

    static {
        actionClasses.put(ABOUT_ACTION, AboutAction.class);
        actionClasses.put(NEW_DOC_ACTION, NewDocAction.class);
        actionClasses.put(OPEN_DOC_ACTION, OpenDocAction.class);
        actionClasses.put(SAVE_DOC_ACTION, SaveDocAction.class);
        actionClasses.put(SAVE_AS_DOC_ACTION, SaveAsDocAction.class);
        actionClasses.put(EXPORT_DOC_ACTION, ExportDocAction.class);
        actionClasses.put(ADD_FIGURE_ACTION, AddFigureAction.class);
        actionClasses.put(REMOVE_FIGURE_ACTION, RemoveFigureAction.class);
        actionClasses.put(MOVE_FIGURE_UP_ACTION, MoveFigureUpAction.class);
        actionClasses.put(MOVE_FIGURE_DOWN_ACTION, MoveFigureDownAction.class);
        actionClasses.put(ANIMATE_ACTION, AnimateAction.class);
        actionClasses.put(MOUSE_CONTROLLED_ACTION, MouseControlledAction.class);
        actionClasses.put(CLEAR_ACTION, ClearAction.class);
        actionClasses.put(FILL_ACTION, FillAction.class);
        actionClasses.put(SHOW_FIGURE_ACTION, ShowFigureAction.class);
        actionClasses.put(SHOW_PICTURE_ACTION, ShowPictureAction.class);
        actionClasses.put(SHOW_GEARS_ACTION, ShowGearsAction.class);
        actionClasses.put(AUTO_FILL_ACTION, AutoFillAction.class);
        actionClasses.put(ANTIALIAS_ACTION, AntialiasAction.class);
        actionClasses.put(OUTER_GEAR_VALUE_ACTION, OuterRadiusValueAction.class);
        actionClasses.put(INNER_GEAR_VALUE_ACTION, InnerRadiusValueAction.class);
        actionClasses.put(PEN_HOLE_POS_VALUE_ACTION, PenHolePosValueAction.class);
        actionClasses.put(CLOSE_ACTION, CloseAction.class);
    }
}

